/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.ormlite.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.holder.HasSimpleLifecycleMethods;
import org.androidannotations.plugin.PluginClassHolder;

public class OrmLiteHolder
extends PluginClassHolder<EComponentHolder> {
    private Map<TypeMirror, JFieldVar> databaseHelperRefs = new HashMap<TypeMirror, JFieldVar>();

    public OrmLiteHolder(EComponentHolder holder) {
        super((GeneratedClassHolder)holder);
    }

    public JFieldVar getDatabaseHelperRef(TypeMirror databaseHelperTypeMirror) {
        JFieldVar databaseHelperRef = this.databaseHelperRefs.get(databaseHelperTypeMirror);
        if (databaseHelperRef == null) {
            databaseHelperRef = this.setDatabaseHelperRef(databaseHelperTypeMirror);
            this.injectReleaseAtEndLifecycle(databaseHelperRef);
        }
        return databaseHelperRef;
    }

    private JFieldVar setDatabaseHelperRef(TypeMirror databaseHelperTypeMirror) {
        AbstractJClass databaseHelperClass = this.getJClass(databaseHelperTypeMirror.toString());
        String fieldName = CaseHelper.lowerCaseFirst((String)databaseHelperClass.name()) + ModelConstants.generationSuffix();
        JFieldVar databaseHelperRef = this.getGeneratedClass().field(4, (AbstractJType)databaseHelperClass, fieldName);
        this.databaseHelperRefs.put(databaseHelperTypeMirror, databaseHelperRef);
        IJExpression dbHelperClass = databaseHelperClass.dotclass();
        ((EComponentHolder)this.holder()).getInitBodyInjectionBlock().assign((IJAssignmentTarget)databaseHelperRef, (IJExpression)this.getJClass("com.j256.ormlite.android.apptools.OpenHelperManager").staticInvoke("getHelper").arg(((EComponentHolder)this.holder()).getContextRef()).arg(dbHelperClass));
        return databaseHelperRef;
    }

    private void injectReleaseAtEndLifecycle(JFieldVar databaseHelperRef) {
        if (this.holder() instanceof HasSimpleLifecycleMethods) {
            JBlock endLifecycleBody = ((HasSimpleLifecycleMethods)this.holder()).getEndLifecycleBeforeSuperBlock();
            endLifecycleBody.staticInvoke(this.getJClass("com.j256.ormlite.android.apptools.OpenHelperManager"), "releaseHelper");
            endLifecycleBody.assign((IJAssignmentTarget)databaseHelperRef, (IJExpression)JExpr._null());
        }
    }
}

