/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.roboguice.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JSynchronizedBlock;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.roboguice.annotations.RoboGuice;
import org.androidannotations.roboguice.api.RoboGuiceHelper;
import org.androidannotations.roboguice.helper.RoboGuiceValidatorHelper;
import org.androidannotations.roboguice.holder.RoboGuiceHolder;

public class RoboGuiceHandler
extends BaseAnnotationHandler<EActivityHolder> {
    private final RoboGuiceValidatorHelper roboGuiceValidatorHelper;

    public RoboGuiceHandler(AndroidAnnotationsEnvironment environment) {
        super(RoboGuice.class, environment);
        this.roboGuiceValidatorHelper = new RoboGuiceValidatorHelper((AnnotationHelper)this.annotationHelper);
    }

    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.hasEActivity(element, validation);
        this.roboGuiceValidatorHelper.hasRoboGuiceJars(validation);
    }

    public void process(Element element, EActivityHolder holder) {
        RoboGuiceHolder roboGuiceHolder = (RoboGuiceHolder)((Object)holder.getPluginHolder((Object)new RoboGuiceHolder(holder)));
        holder.getGeneratedClass()._implements(this.getJClass("roboguice.util.RoboContext"));
        JFieldVar scope = roboGuiceHolder.getScopeField();
        JFieldVar scopedObjects = roboGuiceHolder.getScopedObjectsField();
        JFieldVar eventManager = roboGuiceHolder.getEventManagerField();
        roboGuiceHolder.getContentViewListenerField();
        this.listenerFields(element, holder);
        this.beforeCreateMethod(holder, scope, scopedObjects, eventManager);
        this.onRestartMethod(holder, eventManager);
        this.onStartMethod(holder, eventManager);
        this.onResumeMethod(holder, eventManager);
        this.onPauseMethod(holder, eventManager);
        this.onNewIntentMethod(holder, eventManager);
        this.onStopMethod(holder, eventManager);
        this.onDestroyMethod(holder, eventManager);
        this.onConfigurationChangedMethod(holder, roboGuiceHolder, eventManager);
        this.onContentChangedMethod(roboGuiceHolder, scope, eventManager);
        this.onActivityResultMethod(holder, eventManager);
        this.getScopedObjectMap(holder, scopedObjects);
    }

    private void listenerFields(Element element, EActivityHolder holder) {
        List<TypeMirror> listenerTypeMirrors = this.extractListenerTypeMirrors(element);
        int i = 1;
        for (TypeMirror listenerTypeMirror : listenerTypeMirrors) {
            AbstractJClass listenerClass = this.codeModelHelper.typeMirrorToJClass(listenerTypeMirror);
            JFieldVar listener = holder.getGeneratedClass().field(4, (AbstractJType)listenerClass, "listener" + i + ModelConstants.generationSuffix());
            this.codeModelHelper.addSuppressWarnings((IJAnnotatable)listener, "unused");
            listener.annotate(this.getJClass("com.google.inject.Inject"));
            ++i;
        }
    }

    private List<TypeMirror> extractListenerTypeMirrors(Element activityElement) {
        List<? extends AnnotationMirror> annotationMirrors = activityElement.getAnnotationMirrors();
        String annotationName = RoboGuice.class.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue action = entry.getValue();
                List elements = (List)action.getValue();
                ArrayList<TypeMirror> listenerTypeMirrors = new ArrayList<TypeMirror>(elements.size());
                for (AnnotationValue annotationValue : elements) {
                    listenerTypeMirrors.add((TypeMirror)annotationValue.getValue());
                }
                return listenerTypeMirrors;
            }
        }
        return Collections.emptyList();
    }

    private void beforeCreateMethod(EActivityHolder holder, JFieldVar scope, JFieldVar scopedObjects, JFieldVar eventManager) {
        JBlock body = holder.getInitBody();
        JNarrowedClass keyWildCard = this.getJClass("com.google.inject.Key").narrow(this.getCodeModel().wildcard());
        AbstractJClass scopedHashMap = this.getClasses().HASH_MAP.narrow(new AbstractJClass[]{keyWildCard, this.getClasses().OBJECT});
        body.assign((IJAssignmentTarget)scopedObjects, (IJExpression)JExpr._new((AbstractJClass)scopedHashMap));
        JVar injector = body.decl((AbstractJType)this.getJClass("roboguice.inject.RoboInjector"), "injector_", (IJExpression)this.getJClass("roboguice.RoboGuice").staticInvoke("getInjector").arg((IJExpression)JExpr._this()));
        body.assign((IJAssignmentTarget)scope, (IJExpression)JExpr.invoke((IJExpression)injector, (String)"getInstance").arg(this.getJClass("roboguice.inject.ContextScope").dotclass()));
        body.assign((IJAssignmentTarget)eventManager, (IJExpression)JExpr.invoke((IJExpression)injector, (String)"getInstance").arg(this.getJClass("roboguice.event.EventManager").dotclass()));
        body.add((IJStatement)injector.invoke("injectMembersWithoutViews").arg((IJExpression)JExpr._this()));
        this.fireEvent(eventManager, body, this.getJClass("roboguice.context.event.OnCreateEvent"), new IJExpression[]{holder.getInitSavedInstanceParam()});
    }

    private void onRestartMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onRestartAfterSuperBlock = holder.getOnRestartAfterSuperBlock();
        this.fireEvent(eventManager, onRestartAfterSuperBlock, this.getJClass("roboguice.activity.event.OnRestartEvent"), new IJExpression[0]);
    }

    private void onStartMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onStartAfterSuperBlock = holder.getOnStartAfterSuperBlock();
        this.fireEvent(eventManager, onStartAfterSuperBlock, this.getJClass("roboguice.context.event.OnStartEvent"), new IJExpression[0]);
    }

    private void onResumeMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onResumeAfterSuperBlock = holder.getOnResumeAfterSuperBlock();
        this.fireEvent(eventManager, onResumeAfterSuperBlock, this.getJClass("roboguice.activity.event.OnResumeEvent"), new IJExpression[0]);
    }

    private void onPauseMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onPauseAfterSuperBlock = holder.getOnPauseAfterSuperBlock();
        this.fireEvent(eventManager, onPauseAfterSuperBlock, this.getJClass("roboguice.activity.event.OnPauseEvent"), new IJExpression[0]);
    }

    private void onNewIntentMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onNewIntentAfterSuperBlock = holder.getOnNewIntentAfterSuperBlock();
        this.fireEvent(eventManager, onNewIntentAfterSuperBlock, this.getJClass("roboguice.activity.event.OnNewIntentEvent"), new IJExpression[0]);
    }

    private void onStopMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onStopBlock = new JBlock().bracesRequired(false).indentRequired(false);
        JTryBlock tryBlock = onStopBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.getJClass("roboguice.activity.event.OnStopEvent"), new IJExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((IJExpression)JExpr._super(), "onStop");
        JMethod onStop = holder.getOnStop();
        this.codeModelHelper.replaceSuperCall(onStop, onStopBlock);
    }

    private void onDestroyMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onDestroyBlock = new JBlock().bracesRequired(false).indentRequired(false);
        JTryBlock tryBlock = onDestroyBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.getJClass("roboguice.context.event.OnDestroyEvent"), new IJExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        JTryBlock tryInFinally = finallyBody._try();
        tryInFinally.body().add((IJStatement)this.getJClass("roboguice.RoboGuice").staticInvoke("destroyInjector").arg((IJExpression)JExpr._this()));
        tryInFinally._finally().invoke((IJExpression)JExpr._super(), "onDestroy");
        JMethod onDestroy = holder.getOnDestroy();
        this.codeModelHelper.replaceSuperCall(onDestroy, onDestroyBlock);
    }

    private void onConfigurationChangedMethod(EActivityHolder holder, RoboGuiceHolder roboGuiceHolder, JFieldVar eventManager) {
        JVar currentConfig = roboGuiceHolder.getCurrentConfig();
        JVar newConfig = holder.getOnConfigurationChangedNewConfigParam();
        JBlock onConfigurationChangedAfterSuperBlock = holder.getOnConfigurationChangedAfterSuperBlock();
        this.fireEvent(eventManager, onConfigurationChangedAfterSuperBlock, this.getJClass("roboguice.context.event.OnConfigurationChangedEvent"), new IJExpression[]{currentConfig, newConfig});
    }

    private void onContentChangedMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onContentChangedAfterSuperBlock = holder.getOnContentChangedAfterSuperBlock();
        JSynchronizedBlock synchronizedBlock = onContentChangedAfterSuperBlock.synchronizedBlock(this.getJClass("roboguice.inject.ContextScope").dotclass());
        JBlock synchronizedBlockBody = synchronizedBlock.body();
        synchronizedBlockBody.invoke((IJExpression)scope, "enter").arg((IJExpression)JExpr._this());
        JTryBlock tryBlock = synchronizedBlockBody._try();
        tryBlock.body().staticInvoke(this.getJClass(RoboGuiceHelper.class), "callInjectViews").arg((IJExpression)JExpr._this());
        tryBlock._finally().invoke((IJExpression)scope, "exit").arg((IJExpression)JExpr._this());
        onContentChangedAfterSuperBlock.add((IJStatement)synchronizedBlock);
        this.fireEvent(eventManager, onContentChangedAfterSuperBlock, this.getJClass("roboguice.activity.event.OnContentChangedEvent"), new IJExpression[0]);
    }

    private void onActivityResultMethod(EActivityHolder holder, JFieldVar eventManager) {
        JBlock onActivityResultAfterSuperBlock = holder.getOnActivityResultAfterSuperBlock();
        JVar requestCode = holder.getOnActivityResultRequestCodeParam();
        JVar resultCode = holder.getOnActivityResultResultCodeParam();
        JVar data = holder.getOnActivityResultDataParam();
        this.fireEvent(eventManager, onActivityResultAfterSuperBlock, this.getJClass("roboguice.activity.event.OnActivityResultEvent"), new IJExpression[]{requestCode, resultCode, data});
    }

    private void fireEvent(JFieldVar eventManager, JBlock body, AbstractJClass eventClass, IJExpression ... eventArguments) {
        AbstractJClass actualEventClass = eventClass;
        if (eventClass.fullName().startsWith("roboguice.context.event")) {
            actualEventClass = eventClass.narrow(this.getClasses().ACTIVITY);
        }
        JInvocation newEvent = JExpr._new((AbstractJClass)actualEventClass);
        newEvent.arg((IJExpression)JExpr._this());
        for (IJExpression eventArgument : eventArguments) {
            newEvent.arg(eventArgument);
        }
        body.invoke((IJExpression)eventManager, "fire").arg((IJExpression)newEvent);
    }

    private void getScopedObjectMap(EActivityHolder holder, JFieldVar scopedObjectMap) {
        JMethod getScopedObjectMapMethod = holder.getGeneratedClass().method(1, scopedObjectMap.type(), "getScopedObjectMap");
        getScopedObjectMapMethod.annotate(Override.class);
        getScopedObjectMapMethod.body()._return((IJExpression)scopedObjectMap);
    }
}

