/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.roboguice.helper;

import javax.lang.model.util.Elements;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.AnnotationHelper;

public class RoboGuiceValidatorHelper {
    private AnnotationHelper annotationHelper;

    public RoboGuiceValidatorHelper(AnnotationHelper annotationHelper) {
        this.annotationHelper = annotationHelper;
    }

    public void hasRoboGuiceJars(ElementValidation valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("roboguice.util.RoboContext") == null) {
            valid.addError("Could not find the RoboGuice framework in the classpath, the following class is missing: roboguice.util.RoboContext");
        }
        if (elementUtils.getTypeElement("roboguice.application.RoboApplication") != null) {
            valid.addError("It seems you are using an old version of RoboGuice. Be sure to use version 3.0!");
        }
        if (elementUtils.getTypeElement("roboguice.activity.event.OnStartEvent") != null) {
            valid.addError("It seems you are using an old version of RoboGuice. Be sure to use version 3.0!");
        }
    }
}

