/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse;

import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.androidtransfuse.AnnotationProcessorBase;
import org.androidtransfuse.SupportedAnnotations;
import org.androidtransfuse.annotations.Parcel;
import org.androidtransfuse.annotations.ScopeReference;
import org.androidtransfuse.bootstrap.Bootstrap;
import org.androidtransfuse.bootstrap.Bootstraps;
import org.androidtransfuse.config.ConfigurationScope;
import org.androidtransfuse.config.EnterableScope;
import org.androidtransfuse.processor.ParcelProcessor;
import org.androidtransfuse.processor.ReloadableASTElementFactory;

@SupportedAnnotations(value={Parcel.class})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@Bootstrap
public class ParcelAnnotationProcessor
extends AnnotationProcessorBase {
    @Inject
    private ParcelProcessor parcelProcessor;
    @Inject
    private ReloadableASTElementFactory reloadableASTElementFactory;
    @Inject
    @ScopeReference(value=ConfigurationScope.class)
    private EnterableScope configurationScope;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Bootstraps.getInjector(ParcelAnnotationProcessor.class).add(Singleton.class, ProcessingEnvironment.class, (Object)processingEnv).inject((Object)this);
    }

    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        this.configurationScope.enter();
        this.parcelProcessor.submit(this.reloadableASTElementFactory.buildProviders(roundEnvironment.getElementsAnnotatedWith(Parcel.class)));
        this.parcelProcessor.execute();
        if (roundEnvironment.processingOver()) {
            this.parcelProcessor.checkForErrors();
        }
        this.configurationScope.exit();
        return true;
    }
}

