/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.androidtransfuse.APIModule;
import org.androidtransfuse.AnnotationProcessorBase;
import org.androidtransfuse.SupportedAnnotations;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementConverterFactory;
import org.androidtransfuse.annotations.Activity;
import org.androidtransfuse.annotations.Application;
import org.androidtransfuse.annotations.BroadcastReceiver;
import org.androidtransfuse.annotations.Factory;
import org.androidtransfuse.annotations.Fragment;
import org.androidtransfuse.annotations.ImplementedBy;
import org.androidtransfuse.annotations.ScopeReference;
import org.androidtransfuse.annotations.Service;
import org.androidtransfuse.annotations.TransfuseModule;
import org.androidtransfuse.bootstrap.Bootstrap;
import org.androidtransfuse.bootstrap.Bootstraps;
import org.androidtransfuse.config.ConfigurationScope;
import org.androidtransfuse.config.EnterableScope;
import org.androidtransfuse.model.manifest.Manifest;
import org.androidtransfuse.model.r.RBuilder;
import org.androidtransfuse.model.r.RResource;
import org.androidtransfuse.model.r.RResourceComposite;
import org.androidtransfuse.processor.ReloadableASTElementFactory;
import org.androidtransfuse.processor.TransfuseProcessor;
import org.androidtransfuse.scope.ScopeKey;
import org.androidtransfuse.util.Logger;
import org.androidtransfuse.util.ManifestLocator;
import org.androidtransfuse.util.ManifestSerializer;

@SupportedAnnotations(value={Activity.class, Application.class, BroadcastReceiver.class, Service.class, Fragment.class, TransfuseModule.class, Factory.class, ImplementedBy.class})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@Bootstrap
public class TransfuseAnnotationProcessor
extends AnnotationProcessorBase {
    @Inject
    private ASTElementConverterFactory astElementConverterFactory;
    @Inject
    private ManifestSerializer manifestParser;
    @Inject
    private RBuilder rBuilder;
    @Inject
    private ReloadableASTElementFactory reloadableASTElementFactory;
    @Inject
    private ManifestLocator manifestLocator;
    @Inject
    private Logger logger;
    @Inject
    @ScopeReference(value=ConfigurationScope.class)
    private EnterableScope configurationScope;
    @Inject
    private Provider<TransfuseProcessor> processorProvider;
    @Inject
    private Elements elements;
    private boolean baseModuleConfiguration = false;

    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Bootstraps.getInjector(TransfuseAnnotationProcessor.class).add(Singleton.class, ProcessingEnvironment.class, (Object)processingEnv).inject((Object)this);
    }

    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        Set<? extends Element> applicationTypes;
        long start = System.currentTimeMillis();
        File manifestFile = this.manifestLocator.findManifest();
        Manifest manifest = this.manifestParser.readManifest(manifestFile);
        RResourceComposite r = new RResourceComposite(this.buildR(this.rBuilder, manifest.getApplicationPackage() + ".R"), this.buildR(this.rBuilder, "android.R"));
        this.configurationScope.enter();
        this.configurationScope.seed(ScopeKey.of(File.class).annotatedBy("@javax.inject.Named(value=manifestFile)"), (Object)manifestFile);
        this.configurationScope.seed(ScopeKey.of(RResource.class), (Object)r);
        this.configurationScope.seed(ScopeKey.of(Manifest.class).annotatedBy("@javax.inject.Named(value=originalManifest)"), (Object)manifest);
        TransfuseProcessor transfuseProcessor = (TransfuseProcessor)this.processorProvider.get();
        if (!this.baseModuleConfiguration) {
            transfuseProcessor.submit(TransfuseModule.class, this.reloadableASTElementFactory.buildProviders(Collections.singleton(this.elements.getTypeElement(APIModule.class.getName()))));
            this.baseModuleConfiguration = true;
        }
        if ((applicationTypes = roundEnvironment.getElementsAnnotatedWith(Application.class)).size() > 1) {
            throw new TransfuseAnalysisException("Unable to process with more than one application defined");
        }
        if (applicationTypes.isEmpty()) {
            transfuseProcessor.generateEmptyApplication();
        } else {
            transfuseProcessor.submit(Application.class, this.reloadableASTElementFactory.buildProviders(applicationTypes));
        }
        transfuseProcessor.submit(TransfuseModule.class, this.buildASTCollection(roundEnvironment, TransfuseModule.class));
        transfuseProcessor.submit(ImplementedBy.class, this.buildASTCollection(roundEnvironment, ImplementedBy.class));
        transfuseProcessor.submit(Factory.class, this.buildASTCollection(roundEnvironment, Factory.class));
        transfuseProcessor.submit(Activity.class, this.buildASTCollection(roundEnvironment, Activity.class));
        transfuseProcessor.submit(BroadcastReceiver.class, this.buildASTCollection(roundEnvironment, BroadcastReceiver.class));
        transfuseProcessor.submit(Service.class, this.buildASTCollection(roundEnvironment, Service.class));
        transfuseProcessor.submit(Fragment.class, this.buildASTCollection(roundEnvironment, Fragment.class));
        transfuseProcessor.execute();
        if (roundEnvironment.processingOver()) {
            transfuseProcessor.checkForErrors();
        }
        this.logger.info("Transfuse took " + (System.currentTimeMillis() - start) + "ms to process");
        this.configurationScope.exit();
        return true;
    }

    private RResource buildR(RBuilder rBuilder, String className) {
        TypeElement rTypeElement = this.elements.getTypeElement(className);
        if (rTypeElement != null) {
            Collection<ASTType> rInnerTypes = this.wrapASTCollection(ElementFilter.typesIn(rTypeElement.getEnclosedElements()));
            return rBuilder.buildR(rInnerTypes);
        }
        return null;
    }

    private Collection<Provider<ASTType>> buildASTCollection(RoundEnvironment round, Class<? extends Annotation> annotation) {
        return this.reloadableASTElementFactory.buildProviders(round.getElementsAnnotatedWith(annotation));
    }

    private Collection<ASTType> wrapASTCollection(Collection<? extends Element> elementCollection) {
        return Collections2.transform(elementCollection, (Function)this.astElementConverterFactory.buildASTElementConverter(ASTType.class));
    }
}

