/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.IntentFilterFactory;
import org.androidtransfuse.analysis.MetaDataBuilder;
import org.androidtransfuse.analysis.repository.ActivityComponentBuilderRepositoryFactory;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.annotations.ConfigChanges;
import org.androidtransfuse.annotations.Extra;
import org.androidtransfuse.annotations.LaunchMode;
import org.androidtransfuse.annotations.Layout;
import org.androidtransfuse.annotations.LayoutHandler;
import org.androidtransfuse.annotations.OnCreate;
import org.androidtransfuse.annotations.Preference;
import org.androidtransfuse.annotations.Resource;
import org.androidtransfuse.annotations.ScreenOrientation;
import org.androidtransfuse.annotations.SystemService;
import org.androidtransfuse.annotations.UIOptions;
import org.androidtransfuse.annotations.View;
import org.androidtransfuse.annotations.WindowSoftInputMode;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ContextScopeComponentBuilder;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.componentBuilder.LayoutBuilder;
import org.androidtransfuse.gen.componentBuilder.NoOpLayoutBuilder;
import org.androidtransfuse.gen.componentBuilder.ObservesRegistrationGenerator;
import org.androidtransfuse.gen.variableBuilder.ExtraInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.PreferenceInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.ResourceInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.SystemServiceBindingInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.ViewInjectionNodeBuilder;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.processor.ManifestManager;
import org.androidtransfuse.scope.ContextScopeHolder;
import org.androidtransfuse.util.AnnotationUtil;
import org.androidtransfuse.util.TypeMirrorRunnable;
import org.androidtransfuse.util.TypeMirrorUtil;
import org.apache.commons.lang.StringUtils;

public class ActivityAnalysis
implements Analysis<ComponentDescriptor> {
    private final InjectionPointFactory injectionPointFactory;
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;
    private final Provider<org.androidtransfuse.model.manifest.Activity> manifestActivityProvider;
    private final ActivityComponentBuilderRepositoryFactory activityComponentBuilderRepository;
    private final AnalysisContextFactory analysisContextFactory;
    private final Provider<ASTTypeBuilderVisitor> astTypeBuilderVisitorProvider;
    private final ASTClassFactory astClassFactory;
    private final ManifestManager manifestManager;
    private final IntentFilterFactory intentFilterBuilder;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final MetaDataBuilder metadataBuilder;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final ContextScopeComponentBuilder contextScopeComponentBuilder;
    private final ObservesRegistrationGenerator observesExpressionDecorator;
    private final ViewInjectionNodeBuilder viewVariableBuilder;
    private final ExtraInjectionNodeBuilder extraInjectionNodeBuilder;
    private final SystemServiceBindingInjectionNodeBuilder systemServiceBindingInjectionNodeBuilder;
    private final ResourceInjectionNodeBuilder resourceInjectionNodeBuilder;
    private final PreferenceInjectionNodeBuilder preferenceInjectionNodeBuilder;

    @Inject
    public ActivityAnalysis(InjectionPointFactory injectionPointFactory, InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider, Provider<org.androidtransfuse.model.manifest.Activity> manifestActivityProvider, ActivityComponentBuilderRepositoryFactory activityComponentBuilderRepository, AnalysisContextFactory analysisContextFactory, Provider<ASTTypeBuilderVisitor> astTypeBuilderVisitorProvider, ASTClassFactory astClassFactory, ManifestManager manifestManager, IntentFilterFactory intentFilterBuilder, ComponentBuilderFactory componentBuilderFactory, MetaDataBuilder metadataBuilder, ASTTypeBuilderVisitor astTypeBuilderVisitor, InjectionBindingBuilder injectionBindingBuilder, ContextScopeComponentBuilder contextScopeComponentBuilder, ObservesRegistrationGenerator observesExpressionDecorator, ViewInjectionNodeBuilder viewVariableBuilder, ExtraInjectionNodeBuilder extraInjectionNodeBuilder, SystemServiceBindingInjectionNodeBuilder systemServiceBindingInjectionNodeBuilder, ResourceInjectionNodeBuilder resourceInjectionNodeBuilder, PreferenceInjectionNodeBuilder preferenceInjectionNodeBuilder) {
        this.injectionPointFactory = injectionPointFactory;
        this.injectionNodeBuilderRepositoryFactory = injectionNodeBuilderRepositoryFactory;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        this.manifestActivityProvider = manifestActivityProvider;
        this.activityComponentBuilderRepository = activityComponentBuilderRepository;
        this.analysisContextFactory = analysisContextFactory;
        this.astTypeBuilderVisitorProvider = astTypeBuilderVisitorProvider;
        this.astClassFactory = astClassFactory;
        this.manifestManager = manifestManager;
        this.intentFilterBuilder = intentFilterBuilder;
        this.componentBuilderFactory = componentBuilderFactory;
        this.metadataBuilder = metadataBuilder;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.contextScopeComponentBuilder = contextScopeComponentBuilder;
        this.observesExpressionDecorator = observesExpressionDecorator;
        this.viewVariableBuilder = viewVariableBuilder;
        this.extraInjectionNodeBuilder = extraInjectionNodeBuilder;
        this.systemServiceBindingInjectionNodeBuilder = systemServiceBindingInjectionNodeBuilder;
        this.resourceInjectionNodeBuilder = resourceInjectionNodeBuilder;
        this.preferenceInjectionNodeBuilder = preferenceInjectionNodeBuilder;
    }

    @Override
    public ComponentDescriptor analyze(ASTType input) {
        PackageClass activityClassName;
        org.androidtransfuse.annotations.Activity activityAnnotation = (org.androidtransfuse.annotations.Activity)input.getAnnotation(org.androidtransfuse.annotations.Activity.class);
        ComponentDescriptor activityDescriptor = null;
        if (input.extendsFrom(this.astClassFactory.getType(Activity.class))) {
            PackageClass activityPackageClass = input.getPackageClass();
            activityClassName = this.buildPackageClass(input, activityPackageClass.getClassName());
        } else {
            activityClassName = this.buildPackageClass(input, activityAnnotation.name());
            Layout layoutAnnotation = (Layout)input.getAnnotation(Layout.class);
            LayoutHandler layoutHandlerAnnotation = (LayoutHandler)input.getAnnotation(LayoutHandler.class);
            TypeMirror type = TypeMirrorUtil.getTypeMirror((Runnable)new ActivityTypeMirrorRunnable(activityAnnotation));
            String activityType = type == null ? Activity.class.getName() : ((Object)type).toString();
            Integer layout = layoutAnnotation == null ? null : Integer.valueOf(layoutAnnotation.value());
            AnalysisContext context = this.analysisContextFactory.buildAnalysisContext(this.buildVariableBuilderMap(type));
            InjectionNode layoutHandlerInjectionNode = this.buildLayoutHandlerInjectionNode(layoutHandlerAnnotation, context);
            activityDescriptor = new ComponentDescriptor(activityType, activityClassName);
            this.setupActivityProfile(activityType, activityDescriptor, input, context, layout, layoutHandlerInjectionNode);
        }
        this.setupManifest(activityClassName.getFullyQualifiedName(), activityAnnotation, input);
        return activityDescriptor;
    }

    private InjectionNode buildLayoutHandlerInjectionNode(LayoutHandler layoutHandlerAnnotation, AnalysisContext context) {
        TypeMirror layoutHandlerType;
        if (layoutHandlerAnnotation != null && (layoutHandlerType = TypeMirrorUtil.getTypeMirror((Runnable)new LayoutHandlerTypeMirrorRunnable(layoutHandlerAnnotation))) != null) {
            ASTType layoutHandlerASTType = (ASTType)layoutHandlerType.accept((TypeVisitor)this.astTypeBuilderVisitorProvider.get(), null);
            return this.injectionPointFactory.buildInjectionNode(layoutHandlerASTType, context);
        }
        return null;
    }

    private PackageClass buildPackageClass(ASTType input, String activityName) {
        PackageClass inputPackageClass = input.getPackageClass();
        if (StringUtils.isBlank((String)activityName)) {
            return inputPackageClass.append("Activity");
        }
        return inputPackageClass.replaceName(activityName);
    }

    private void setupManifest(String name, org.androidtransfuse.annotations.Activity activityAnnotation, ASTType type) {
        org.androidtransfuse.model.manifest.Activity manifestActivity = this.buildManifestEntry(name, activityAnnotation);
        manifestActivity.setIntentFilters(this.intentFilterBuilder.buildIntentFilters(type));
        manifestActivity.setMetaData(this.metadataBuilder.buildMetaData(type));
        this.manifestManager.addActivity(manifestActivity);
    }

    protected org.androidtransfuse.model.manifest.Activity buildManifestEntry(String name, org.androidtransfuse.annotations.Activity activityAnnotation) {
        org.androidtransfuse.model.manifest.Activity manifestActivity = (org.androidtransfuse.model.manifest.Activity)this.manifestActivityProvider.get();
        manifestActivity.setName(name);
        manifestActivity.setLabel(AnnotationUtil.checkBlank((String)activityAnnotation.label()));
        manifestActivity.setAllowTaskReparenting((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.allowTaskReparenting(), (Object)false));
        manifestActivity.setAlwaysRetainTaskState((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.alwaysRetainTaskState(), (Object)false));
        manifestActivity.setClearTaskOnLaunch((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.clearTaskOnLaunch(), (Object)false));
        manifestActivity.setConfigChanges(this.concatenate(activityAnnotation.configChanges()));
        manifestActivity.setEnabled((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.enabled(), (Object)true));
        manifestActivity.setExcludeFromRecents((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.excludeFromRecents(), (Object)false));
        manifestActivity.setExported(activityAnnotation.exported().getValue());
        manifestActivity.setFinishOnTaskLaunch((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.finishOnTaskLaunch(), (Object)false));
        manifestActivity.setHardwareAccelerated((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.hardwareAccelerated(), (Object)false));
        manifestActivity.setIcon(AnnotationUtil.checkBlank((String)activityAnnotation.icon()));
        manifestActivity.setLaunchMode((LaunchMode)AnnotationUtil.checkDefault((Object)activityAnnotation.launchMode(), (Object)LaunchMode.STANDARD));
        manifestActivity.setMultiprocess((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.multiprocess(), (Object)false));
        manifestActivity.setNoHistory((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.noHistory(), (Object)false));
        manifestActivity.setPermission(AnnotationUtil.checkBlank((String)activityAnnotation.permission()));
        manifestActivity.setProcess(AnnotationUtil.checkBlank((String)activityAnnotation.process()));
        manifestActivity.setScreenOrientation((ScreenOrientation)AnnotationUtil.checkDefault((Object)activityAnnotation.screenOrientation(), (Object)ScreenOrientation.UNSPECIFIED));
        manifestActivity.setStateNotNeeded((Boolean)AnnotationUtil.checkDefault((Object)activityAnnotation.stateNotNeeded(), (Object)false));
        manifestActivity.setTaskAffinity(AnnotationUtil.checkBlank((String)activityAnnotation.taskAffinity()));
        manifestActivity.setTheme(AnnotationUtil.checkBlank((String)activityAnnotation.theme()));
        manifestActivity.setUiOptions((UIOptions)AnnotationUtil.checkDefault((Object)activityAnnotation.uiOptions(), (Object)UIOptions.NONE));
        manifestActivity.setWindowSoftInputMode((WindowSoftInputMode)AnnotationUtil.checkDefault((Object)activityAnnotation.windowSoftInputMode(), (Object)WindowSoftInputMode.STATE_UNSPECIFIED));
        return manifestActivity;
    }

    private String concatenate(ConfigChanges[] configChanges) {
        if (configChanges.length == 0) {
            return null;
        }
        return StringUtils.join((Object[])configChanges, (String)"|");
    }

    private void setupActivityProfile(String activityType, ComponentDescriptor activityDescriptor, ASTType astType, AnalysisContext context, Integer layout, InjectionNode layoutHandlerInjectionNode) {
        LayoutBuilder layoutBuilder = layout == null ? (layoutHandlerInjectionNode == null ? new NoOpLayoutBuilder() : this.componentBuilderFactory.buildLayoutHandlerBuilder(layoutHandlerInjectionNode)) : this.componentBuilderFactory.buildRLayoutBuilder(layout);
        ASTMethod onCreateASTMethod = this.getASTMethod("onCreate", Bundle.class);
        activityDescriptor.setInitMethodBuilder(this.astClassFactory.getType(OnCreate.class), this.componentBuilderFactory.buildOnCreateMethodBuilder(onCreateASTMethod, layoutBuilder));
        activityDescriptor.setInjectionNodeFactory((InjectionNodeFactory)this.componentBuilderFactory.buildInjectionNodeFactory((ImmutableSet<ASTAnnotation>)ImmutableSet.of(), astType, context));
        activityDescriptor.addGenerators(this.activityComponentBuilderRepository.build().getGenerators(activityType));
        activityDescriptor.addGenerators(this.contextScopeComponentBuilder);
        activityDescriptor.addRegistration(this.observesExpressionDecorator);
    }

    private ASTMethod getASTMethod(String methodName, Class ... args) {
        return this.getASTMethod(Activity.class, methodName, args);
    }

    private ASTMethod getASTMethod(Class type, String methodName, Class ... args) {
        try {
            return this.astClassFactory.getMethod(type.getDeclaredMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while trying to reference method " + methodName, (Throwable)e);
        }
    }

    private InjectionNodeBuilderRepository buildVariableBuilderMap(TypeMirror activityType) {
        InjectionNodeBuilderRepository injectionNodeBuilderRepository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        injectionNodeBuilderRepository.putType(Context.class, this.injectionBindingBuilder.buildThis(Context.class));
        injectionNodeBuilderRepository.putType(Application.class, this.injectionBindingBuilder.dependency(Context.class).invoke(Application.class, "getApplication").build());
        injectionNodeBuilderRepository.putType(Activity.class, this.injectionBindingBuilder.buildThis(Activity.class));
        injectionNodeBuilderRepository.putType(ContextScopeHolder.class, this.injectionBindingBuilder.buildThis(ContextScopeHolder.class));
        if (activityType != null && !((Object)activityType).toString().equals(Activity.class.getName())) {
            ASTType activityASTType = (ASTType)activityType.accept(this.astTypeBuilderVisitor, null);
            injectionNodeBuilderRepository.putType(activityASTType, this.injectionBindingBuilder.buildThis(activityASTType));
        }
        injectionNodeBuilderRepository.putAnnotation(Extra.class, (InjectionNodeBuilder)this.extraInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(Resource.class, (InjectionNodeBuilder)this.resourceInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(SystemService.class, (InjectionNodeBuilder)this.systemServiceBindingInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(Preference.class, (InjectionNodeBuilder)this.preferenceInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(View.class, (InjectionNodeBuilder)this.viewVariableBuilder);
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildApplicationInjections());
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildModuleConfiguration());
        return injectionNodeBuilderRepository;
    }

    private static class LayoutHandlerTypeMirrorRunnable
    extends TypeMirrorRunnable<LayoutHandler> {
        public LayoutHandlerTypeMirrorRunnable(LayoutHandler layoutHandlerAnnotation) {
            super(layoutHandlerAnnotation);
        }

        @Override
        public void run(LayoutHandler annotation) {
            annotation.value();
        }
    }

    private static class ActivityTypeMirrorRunnable
    extends TypeMirrorRunnable<org.androidtransfuse.annotations.Activity> {
        public ActivityTypeMirrorRunnable(org.androidtransfuse.annotations.Activity activityAnnotation) {
            super(activityAnnotation);
        }

        @Override
        public void run(org.androidtransfuse.annotations.Activity annotation) {
            annotation.type();
        }
    }
}

