/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import android.content.Context;
import android.content.res.Configuration;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.annotations.OnConfigurationChanged;
import org.androidtransfuse.annotations.OnCreate;
import org.androidtransfuse.annotations.OnLowMemory;
import org.androidtransfuse.annotations.OnTerminate;
import org.androidtransfuse.annotations.UIOptions;
import org.androidtransfuse.gen.ManifestBuilder;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ContextScopeComponentBuilder;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.componentBuilder.MethodCallbackGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodGenerator;
import org.androidtransfuse.gen.componentBuilder.NoOpLayoutBuilder;
import org.androidtransfuse.gen.componentBuilder.ObservesRegistrationGenerator;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.manifest.Application;
import org.androidtransfuse.processor.ManifestManager;
import org.androidtransfuse.scope.ContextScopeHolder;
import org.androidtransfuse.util.AnnotationUtil;
import org.apache.commons.lang.StringUtils;

public class ApplicationAnalysis
implements Analysis<ComponentDescriptor> {
    private final InjectionNodeBuilderRepositoryFactory variableBuilderRepositoryFactory;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final ASTClassFactory astClassFactory;
    private final AnalysisContextFactory analysisContextFactory;
    private final ManifestManager manifestManager;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final ContextScopeComponentBuilder contextScopeComponentBuilder;
    private final ObservesRegistrationGenerator observesExpressionDecorator;
    private final ManifestBuilder manifestBuilder;

    @Inject
    public ApplicationAnalysis(InjectionNodeBuilderRepositoryFactory variableBuilderRepositoryFactory, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider, ComponentBuilderFactory componentBuilderFactory, ASTClassFactory astClassFactory, AnalysisContextFactory analysisContextFactory, ManifestManager manifestManager, InjectionBindingBuilder injectionBindingBuilder, ContextScopeComponentBuilder contextScopeComponentBuilder, ObservesRegistrationGenerator observesExpressionDecorator, ManifestBuilder manifestBuilder) {
        this.variableBuilderRepositoryFactory = variableBuilderRepositoryFactory;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        this.componentBuilderFactory = componentBuilderFactory;
        this.astClassFactory = astClassFactory;
        this.analysisContextFactory = analysisContextFactory;
        this.manifestManager = manifestManager;
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.contextScopeComponentBuilder = contextScopeComponentBuilder;
        this.observesExpressionDecorator = observesExpressionDecorator;
        this.manifestBuilder = manifestBuilder;
    }

    @Override
    public ComponentDescriptor analyze(ASTType astType) {
        org.androidtransfuse.annotations.Application applicationAnnotation = (org.androidtransfuse.annotations.Application)astType.getAnnotation(org.androidtransfuse.annotations.Application.class);
        PackageClass inputType = astType.getPackageClass();
        PackageClass applicationClassName = StringUtils.isBlank((String)applicationAnnotation.name()) ? inputType.append("Application") : inputType.replaceName(applicationAnnotation.name());
        ComponentDescriptor applicationDescriptor = new ComponentDescriptor(android.app.Application.class.getName(), applicationClassName);
        AnalysisContext analysisContext = this.analysisContextFactory.buildAnalysisContext(this.buildVariableBuilderMap());
        this.setupApplicationProfile(applicationDescriptor, astType, analysisContext);
        this.setupManifest(applicationAnnotation, applicationDescriptor.getPackageClass().getFullyQualifiedName(), applicationAnnotation.label());
        return applicationDescriptor;
    }

    private void setupApplicationProfile(ComponentDescriptor applicationDescriptor, ASTType astType, AnalysisContext context) {
        ASTMethod onCreateASTMethod = this.getASTMethod("onCreate", new Class[0]);
        applicationDescriptor.setInitMethodBuilder(this.astClassFactory.getType(OnCreate.class), this.componentBuilderFactory.buildOnCreateMethodBuilder(onCreateASTMethod, new NoOpLayoutBuilder()));
        applicationDescriptor.setInjectionNodeFactory((InjectionNodeFactory)this.componentBuilderFactory.buildInjectionNodeFactory((ImmutableSet<ASTAnnotation>)ImmutableSet.of(), astType, context));
        applicationDescriptor.addGenerators(this.buildEventMethod(OnLowMemory.class, "onLowMemory"));
        applicationDescriptor.addGenerators(this.buildEventMethod(OnTerminate.class, "onTerminate"));
        ASTMethod onConfigurationChangedASTMethod = this.getASTMethod("onConfigurationChanged", Configuration.class);
        applicationDescriptor.addGenerators(this.componentBuilderFactory.buildMethodCallbackGenerator(this.astClassFactory.getType(OnConfigurationChanged.class), (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(onConfigurationChangedASTMethod, true)));
        applicationDescriptor.addGenerators(this.contextScopeComponentBuilder);
        applicationDescriptor.addRegistration(this.observesExpressionDecorator);
    }

    private MethodCallbackGenerator buildEventMethod(Class<? extends Annotation> eventAnnotationClass, String methodName) {
        ASTMethod method = this.getASTMethod(methodName, new Class[0]);
        ASTType eventAnnotation = this.astClassFactory.getType(eventAnnotationClass);
        return this.componentBuilderFactory.buildMethodCallbackGenerator(eventAnnotation, (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(method, true));
    }

    private ASTMethod getASTMethod(String methodName, Class ... args) {
        try {
            return this.astClassFactory.getMethod(android.app.Application.class.getDeclaredMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while trying to reference method " + methodName, (Throwable)e);
        }
    }

    private InjectionNodeBuilderRepository buildVariableBuilderMap() {
        InjectionNodeBuilderRepository injectionNodeBuilderRepository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        injectionNodeBuilderRepository.putType(Context.class, this.injectionBindingBuilder.buildThis(Context.class));
        injectionNodeBuilderRepository.putType(android.app.Application.class, this.injectionBindingBuilder.buildThis(android.app.Application.class));
        injectionNodeBuilderRepository.putType(ContextScopeHolder.class, this.injectionBindingBuilder.buildThis(ContextScopeHolder.class));
        injectionNodeBuilderRepository.addRepository(this.variableBuilderRepositoryFactory.buildApplicationInjections());
        injectionNodeBuilderRepository.addRepository(this.variableBuilderRepositoryFactory.buildModuleConfiguration());
        return injectionNodeBuilderRepository;
    }

    private void setupManifest(org.androidtransfuse.annotations.Application annotation, String name, String label) {
        Application manifestApplication = this.manifestBuilder.setupManifestApplication(name);
        manifestApplication.setLabel(AnnotationUtil.checkBlank((String)label));
        manifestApplication.setAllowTaskReparenting((Boolean)AnnotationUtil.checkDefault((Object)annotation.allowTaskReparenting(), (Object)false));
        manifestApplication.setBackupAgent(AnnotationUtil.checkBlank((String)annotation.backupAgent()));
        manifestApplication.setDebuggable((Boolean)AnnotationUtil.checkDefault((Object)annotation.debuggable(), (Object)false));
        manifestApplication.setDescription(AnnotationUtil.checkBlank((String)annotation.description()));
        manifestApplication.setEnabled((Boolean)AnnotationUtil.checkDefault((Object)annotation.enabled(), (Object)true));
        manifestApplication.setHasCode((Boolean)AnnotationUtil.checkDefault((Object)annotation.hasCode(), (Object)true));
        manifestApplication.setHardwareAccelerated((Boolean)AnnotationUtil.checkDefault((Object)annotation.hardwareAccelerated(), (Object)false));
        manifestApplication.setIcon(AnnotationUtil.checkBlank((String)annotation.icon()));
        manifestApplication.setKillAfterRestore((Boolean)AnnotationUtil.checkDefault((Object)annotation.killAfterRestore(), (Object)true));
        manifestApplication.setLogo(AnnotationUtil.checkBlank((String)annotation.logo()));
        manifestApplication.setManageSpaceActivity(AnnotationUtil.checkBlank((String)annotation.manageSpaceActivity()));
        manifestApplication.setPermission(AnnotationUtil.checkBlank((String)annotation.permission()));
        manifestApplication.setPersistent((Boolean)AnnotationUtil.checkDefault((Object)annotation.persistent(), (Object)false));
        manifestApplication.setProcess(AnnotationUtil.checkBlank((String)annotation.process()));
        manifestApplication.setRestoreAnyVersion((Boolean)AnnotationUtil.checkDefault((Object)annotation.restoreAnyVersion(), (Object)false));
        manifestApplication.setTaskAffinity(AnnotationUtil.checkBlank((String)annotation.taskAffinity()));
        manifestApplication.setTheme(AnnotationUtil.checkBlank((String)annotation.theme()));
        manifestApplication.setUiOptions((UIOptions)AnnotationUtil.checkDefault((Object)annotation.uiOptions(), (Object)UIOptions.NONE));
        this.manifestManager.setApplication(manifestApplication);
    }
}

