/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import android.content.BroadcastReceiver;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.IntentFilterFactory;
import org.androidtransfuse.analysis.MetaDataBuilder;
import org.androidtransfuse.annotations.OnReceive;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ContextScopeComponentBuilder;
import org.androidtransfuse.gen.componentBuilder.ObservesRegistrationGenerator;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.manifest.Receiver;
import org.androidtransfuse.processor.ManifestManager;
import org.androidtransfuse.util.AnnotationUtil;
import org.androidtransfuse.util.TypeMirrorRunnable;
import org.androidtransfuse.util.TypeMirrorUtil;
import org.apache.commons.lang.StringUtils;

public class BroadcastReceiverAnalysis
implements Analysis<ComponentDescriptor> {
    private final ASTClassFactory astClassFactory;
    private final Provider<Receiver> receiverProvider;
    private final ManifestManager manifestManager;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final IntentFilterFactory intentFilterBuilder;
    private final MetaDataBuilder metaDataBuilder;
    private final ContextScopeComponentBuilder contextScopeComponentBuilder;
    private final ObservesRegistrationGenerator observesExpressionDecorator;

    @Inject
    public BroadcastReceiverAnalysis(ASTClassFactory astClassFactory, Provider<Receiver> receiverProvider, ManifestManager manifestManager, ComponentBuilderFactory componentBuilderFactory, IntentFilterFactory intentFilterBuilder, MetaDataBuilder metaDataBuilder, ContextScopeComponentBuilder contextScopeComponentBuilder, ObservesRegistrationGenerator observesExpressionDecorator) {
        this.astClassFactory = astClassFactory;
        this.receiverProvider = receiverProvider;
        this.manifestManager = manifestManager;
        this.componentBuilderFactory = componentBuilderFactory;
        this.intentFilterBuilder = intentFilterBuilder;
        this.metaDataBuilder = metaDataBuilder;
        this.contextScopeComponentBuilder = contextScopeComponentBuilder;
        this.observesExpressionDecorator = observesExpressionDecorator;
    }

    @Override
    public ComponentDescriptor analyze(ASTType astType) {
        PackageClass receiverClassName;
        org.androidtransfuse.annotations.BroadcastReceiver broadcastReceiver = (org.androidtransfuse.annotations.BroadcastReceiver)astType.getAnnotation(org.androidtransfuse.annotations.BroadcastReceiver.class);
        ComponentDescriptor receiverDescriptor = null;
        if (astType.extendsFrom(this.astClassFactory.getType(BroadcastReceiver.class))) {
            PackageClass activityPackageClass = astType.getPackageClass();
            receiverClassName = this.buildPackageClass(astType, activityPackageClass.getClassName());
        } else {
            receiverClassName = this.buildPackageClass(astType, broadcastReceiver.name());
            TypeMirror type = TypeMirrorUtil.getTypeMirror((Runnable)new ReceiverTypeRunnable(broadcastReceiver));
            String receiverType = this.buildReceiverType(type);
            receiverDescriptor = new ComponentDescriptor(receiverType, receiverClassName);
            receiverDescriptor.setInjectionNodeFactory(this.componentBuilderFactory.buildBroadcastReceiverInjectionNodeFactory(astType));
            receiverDescriptor.setInitMethodBuilder(this.astClassFactory.getType(OnReceive.class), this.componentBuilderFactory.buildOnReceiveMethodBuilder());
            receiverDescriptor.addGenerators(this.contextScopeComponentBuilder);
            receiverDescriptor.addRegistration(this.observesExpressionDecorator);
        }
        this.setupManifest(receiverClassName.getFullyQualifiedName(), broadcastReceiver, astType);
        return receiverDescriptor;
    }

    private String buildReceiverType(TypeMirror type) {
        if (type != null) {
            return ((Object)type).toString();
        }
        return BroadcastReceiver.class.getName();
    }

    private void setupManifest(String name, org.androidtransfuse.annotations.BroadcastReceiver annotation, ASTType astType) {
        Receiver manifestReceiver = this.buildReceiver(name, annotation);
        manifestReceiver.setIntentFilters(this.intentFilterBuilder.buildIntentFilters(astType));
        manifestReceiver.setMetaData(this.metaDataBuilder.buildMetaData(astType));
        this.manifestManager.addBroadcastReceiver(manifestReceiver);
    }

    protected Receiver buildReceiver(String name, org.androidtransfuse.annotations.BroadcastReceiver annotation) {
        Receiver manifestReceiver = (Receiver)this.receiverProvider.get();
        manifestReceiver.setName(name);
        manifestReceiver.setLabel(AnnotationUtil.checkBlank((String)annotation.label()));
        manifestReceiver.setProcess(AnnotationUtil.checkBlank((String)annotation.process()));
        manifestReceiver.setPermission(AnnotationUtil.checkBlank((String)annotation.permission()));
        manifestReceiver.setIcon(AnnotationUtil.checkBlank((String)annotation.icon()));
        manifestReceiver.setEnabled((Boolean)AnnotationUtil.checkDefault((Object)annotation.enabled(), (Object)true));
        manifestReceiver.setExported((Boolean)AnnotationUtil.checkDefault((Object)annotation.exported(), (Object)true));
        return manifestReceiver;
    }

    private PackageClass buildPackageClass(ASTType astType, String className) {
        PackageClass inputPackageClass = astType.getPackageClass();
        if (StringUtils.isBlank((String)className)) {
            return inputPackageClass.append("BroadcastReceiver");
        }
        return inputPackageClass.replaceName(className);
    }

    private static final class ReceiverTypeRunnable
    extends TypeMirrorRunnable<org.androidtransfuse.annotations.BroadcastReceiver> {
        private ReceiverTypeRunnable(org.androidtransfuse.annotations.BroadcastReceiver receiverAnnotation) {
            super(receiverAnnotation);
        }

        @Override
        public void run(org.androidtransfuse.annotations.BroadcastReceiver annotation) {
            annotation.type();
        }
    }
}

