/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import android.app.Activity;
import android.app.Application;
import android.app.ListActivity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.ListFragment;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ListView;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.annotations.Extra;
import org.androidtransfuse.annotations.Fragment;
import org.androidtransfuse.annotations.Layout;
import org.androidtransfuse.annotations.OnActivityCreated;
import org.androidtransfuse.annotations.OnConfigurationChanged;
import org.androidtransfuse.annotations.OnCreate;
import org.androidtransfuse.annotations.OnDestroy;
import org.androidtransfuse.annotations.OnDestroyView;
import org.androidtransfuse.annotations.OnDetach;
import org.androidtransfuse.annotations.OnListItemClick;
import org.androidtransfuse.annotations.OnLowMemory;
import org.androidtransfuse.annotations.OnPause;
import org.androidtransfuse.annotations.OnResume;
import org.androidtransfuse.annotations.OnStart;
import org.androidtransfuse.annotations.OnStop;
import org.androidtransfuse.annotations.Preference;
import org.androidtransfuse.annotations.Resource;
import org.androidtransfuse.annotations.SystemService;
import org.androidtransfuse.annotations.View;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.componentBuilder.ListenerRegistrationGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodCallbackGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodGenerator;
import org.androidtransfuse.gen.componentBuilder.ObservesRegistrationGenerator;
import org.androidtransfuse.gen.variableBuilder.ExtraInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.FragmentViewInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.PreferenceInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.ResourceInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.SystemServiceBindingInjectionNodeBuilder;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.scope.ContextScopeHolder;
import org.androidtransfuse.util.TypeMirrorRunnable;
import org.androidtransfuse.util.TypeMirrorUtil;
import org.apache.commons.lang.StringUtils;

public class FragmentAnalysis
implements Analysis<ComponentDescriptor> {
    private final ASTClassFactory astClassFactory;
    private final AnalysisContextFactory analysisContextFactory;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final ListenerRegistrationGenerator listenerRegistrationGenerator;
    private final ObservesRegistrationGenerator observesExpressionDecorator;
    private final ExtraInjectionNodeBuilder extraInjectionNodeBuilder;
    private final SystemServiceBindingInjectionNodeBuilder systemServiceBindingInjectionNodeBuilder;
    private final ResourceInjectionNodeBuilder resourceInjectionNodeBuilder;
    private final PreferenceInjectionNodeBuilder preferenceInjectionNodeBuilder;
    private final FragmentViewInjectionNodeBuilder fragmentViewInjectionNodeBuilder;

    @Inject
    public FragmentAnalysis(ASTClassFactory astClassFactory, AnalysisContextFactory analysisContextFactory, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider, InjectionBindingBuilder injectionBindingBuilder, ASTTypeBuilderVisitor astTypeBuilderVisitor, InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory, ComponentBuilderFactory componentBuilderFactory, ListenerRegistrationGenerator listenerRegistrationGenerator, ObservesRegistrationGenerator observesExpressionDecorator, ExtraInjectionNodeBuilder extraInjectionNodeBuilder, SystemServiceBindingInjectionNodeBuilder systemServiceBindingInjectionNodeBuilder, ResourceInjectionNodeBuilder resourceInjectionNodeBuilder, PreferenceInjectionNodeBuilder preferenceInjectionNodeBuilder, FragmentViewInjectionNodeBuilder fragmentViewInjectionNodeBuilder) {
        this.astClassFactory = astClassFactory;
        this.analysisContextFactory = analysisContextFactory;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.injectionNodeBuilderRepositoryFactory = injectionNodeBuilderRepositoryFactory;
        this.componentBuilderFactory = componentBuilderFactory;
        this.extraInjectionNodeBuilder = extraInjectionNodeBuilder;
        this.systemServiceBindingInjectionNodeBuilder = systemServiceBindingInjectionNodeBuilder;
        this.resourceInjectionNodeBuilder = resourceInjectionNodeBuilder;
        this.preferenceInjectionNodeBuilder = preferenceInjectionNodeBuilder;
        this.fragmentViewInjectionNodeBuilder = fragmentViewInjectionNodeBuilder;
        this.listenerRegistrationGenerator = listenerRegistrationGenerator;
        this.observesExpressionDecorator = observesExpressionDecorator;
    }

    @Override
    public ComponentDescriptor analyze(ASTType astType) {
        Fragment fragmentAnnotation = (Fragment)astType.getAnnotation(Fragment.class);
        ComponentDescriptor fragmentDescriptor = null;
        if (!astType.extendsFrom(this.astClassFactory.getType(android.support.v4.app.Fragment.class))) {
            PackageClass fragmentClassName = this.buildPackageClass(astType, fragmentAnnotation.name());
            Layout layoutAnnotation = (Layout)astType.getAnnotation(Layout.class);
            TypeMirror type = TypeMirrorUtil.getTypeMirror((Runnable)new FragmentTypeMirrorRunnable(fragmentAnnotation));
            ASTType fragmentType = type == null ? this.astClassFactory.getType(android.support.v4.app.Fragment.class) : (ASTType)type.accept(this.astTypeBuilderVisitor, null);
            Integer layout = layoutAnnotation == null ? null : Integer.valueOf(layoutAnnotation.value());
            AnalysisContext context = this.analysisContextFactory.buildAnalysisContext(this.buildVariableBuilderMap(type));
            fragmentDescriptor = new ComponentDescriptor(fragmentType.getName(), fragmentClassName);
            this.setupFragmentProfile(fragmentDescriptor, astType, fragmentType, context, layout);
        }
        return fragmentDescriptor;
    }

    private void setupFragmentProfile(ComponentDescriptor fragmentDescriptor, ASTType astType, ASTType fragmentType, AnalysisContext context, Integer layout) {
        ASTMethod onCreateViewMethod = this.getASTMethod("onCreateView", LayoutInflater.class, ViewGroup.class, Bundle.class);
        fragmentDescriptor.setInitMethodBuilder(this.astClassFactory.getType(OnCreate.class), this.componentBuilderFactory.buildFragmentMethodBuilder(layout, onCreateViewMethod));
        fragmentDescriptor.setInjectionNodeFactory((InjectionNodeFactory)this.componentBuilderFactory.buildInjectionNodeFactory((ImmutableSet<ASTAnnotation>)ImmutableSet.of(), astType, context));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnActivityCreated.class, "onActivityCreated", Bundle.class));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnStart.class, "onStart", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnResume.class, "onResume", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnPause.class, "onPause", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnStop.class, "onStop", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnDestroyView.class, "onDestroyView", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnDestroy.class, "onDestroy", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnDetach.class, "onDetach", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnLowMemory.class, "onLowMemory", new Class[0]));
        fragmentDescriptor.addGenerators(this.buildEventMethod(OnConfigurationChanged.class, "onConfigurationChanged", Configuration.class));
        if (fragmentType.extendsFrom(this.astClassFactory.getType(ListFragment.class))) {
            ASTMethod onListItemClickMethod = this.getASTMethod(ListActivity.class, "onListItemClick", ListView.class, android.view.View.class, Integer.TYPE, Long.TYPE);
            fragmentDescriptor.addGenerators(this.componentBuilderFactory.buildMethodCallbackGenerator(this.astClassFactory.getType(OnListItemClick.class), (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(onListItemClickMethod, false)));
        }
        fragmentDescriptor.addGenerators(this.listenerRegistrationGenerator);
        fragmentDescriptor.addRegistration(this.observesExpressionDecorator);
    }

    private MethodCallbackGenerator buildEventMethod(Class<? extends Annotation> eventAnnotationClass, String methodName, Class ... args) {
        ASTMethod method = this.getASTMethod(methodName, args);
        ASTType eventAnnotation = this.astClassFactory.getType(eventAnnotationClass);
        return this.componentBuilderFactory.buildMethodCallbackGenerator(eventAnnotation, (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(method, true));
    }

    private ASTMethod getASTMethod(String methodName, Class ... args) {
        return this.getASTMethod(android.support.v4.app.Fragment.class, methodName, args);
    }

    private ASTMethod getASTMethod(Class type, String methodName, Class ... args) {
        try {
            return this.astClassFactory.getMethod(type.getDeclaredMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while trying to reference method " + methodName, (Throwable)e);
        }
    }

    private InjectionNodeBuilderRepository buildVariableBuilderMap(TypeMirror type) {
        InjectionNodeBuilderRepository injectionNodeBuilderRepository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        injectionNodeBuilderRepository.putType(android.support.v4.app.Fragment.class, this.injectionBindingBuilder.buildThis(android.support.v4.app.Fragment.class));
        injectionNodeBuilderRepository.putType(Activity.class, this.injectionBindingBuilder.dependency(android.support.v4.app.Fragment.class).invoke(Activity.class, "getActivity").build());
        injectionNodeBuilderRepository.putType(Context.class, this.injectionBindingBuilder.dependency(android.support.v4.app.Fragment.class).invoke(Context.class, "getActivity").build());
        injectionNodeBuilderRepository.putType(FragmentManager.class, this.injectionBindingBuilder.dependency(android.support.v4.app.Fragment.class).invoke(FragmentManager.class, "getFragmentManager").build());
        injectionNodeBuilderRepository.putType(Application.class, this.injectionBindingBuilder.dependency(Activity.class).invoke(Application.class, "getApplication").build());
        injectionNodeBuilderRepository.putType(ContextScopeHolder.class, this.injectionBindingBuilder.dependency(android.support.v4.app.Fragment.class).invoke(Activity.class, "getActivity").build());
        if (type != null && !((Object)type).toString().equals(android.support.v4.app.Fragment.class.getName())) {
            ASTType fragmentASTType = (ASTType)type.accept(this.astTypeBuilderVisitor, null);
            injectionNodeBuilderRepository.putType(fragmentASTType, this.injectionBindingBuilder.buildThis(fragmentASTType));
        }
        injectionNodeBuilderRepository.putAnnotation(Extra.class, (InjectionNodeBuilder)this.extraInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(Resource.class, (InjectionNodeBuilder)this.resourceInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(SystemService.class, (InjectionNodeBuilder)this.systemServiceBindingInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(Preference.class, (InjectionNodeBuilder)this.preferenceInjectionNodeBuilder);
        injectionNodeBuilderRepository.putAnnotation(View.class, (InjectionNodeBuilder)this.fragmentViewInjectionNodeBuilder);
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildApplicationInjections());
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildModuleConfiguration());
        return injectionNodeBuilderRepository;
    }

    private PackageClass buildPackageClass(ASTType input, String fragmentName) {
        PackageClass inputPackageClass = input.getPackageClass();
        if (StringUtils.isBlank((String)fragmentName)) {
            return inputPackageClass.append("Fragment");
        }
        return inputPackageClass.replaceName(fragmentName);
    }

    private static final class FragmentTypeMirrorRunnable
    extends TypeMirrorRunnable<Fragment> {
        public FragmentTypeMirrorRunnable(Fragment fragmentAnnotation) {
            super(fragmentAnnotation);
        }

        @Override
        public void run(Fragment annotation) {
            annotation.type();
        }
    }
}

