/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.annotations.Intent;
import org.androidtransfuse.annotations.IntentFilter;
import org.androidtransfuse.annotations.IntentFilters;
import org.androidtransfuse.model.manifest.Action;
import org.androidtransfuse.model.manifest.Category;
import org.androidtransfuse.util.AnnotationUtil;

public class IntentFilterFactory {
    private final Provider<org.androidtransfuse.model.manifest.IntentFilter> intentFilterProvider;
    private final Provider<Action> actionProvider;
    private final Provider<Category> categoryProvider;

    @Inject
    public IntentFilterFactory(Provider<org.androidtransfuse.model.manifest.IntentFilter> intentFilterProvider, Provider<Action> actionProvider, Provider<Category> categoryProvider) {
        this.intentFilterProvider = intentFilterProvider;
        this.actionProvider = actionProvider;
        this.categoryProvider = categoryProvider;
    }

    public List<org.androidtransfuse.model.manifest.IntentFilter> buildIntentFilters(ASTType astType) {
        IntentFilters intentFilters = (IntentFilters)astType.getAnnotation(IntentFilters.class);
        IntentFilter intentFilter = (IntentFilter)astType.getAnnotation(IntentFilter.class);
        Intent intent = (Intent)astType.getAnnotation(Intent.class);
        ArrayList<org.androidtransfuse.model.manifest.IntentFilter> convertedIntentFilters = new ArrayList<org.androidtransfuse.model.manifest.IntentFilter>();
        if (intentFilters != null) {
            for (IntentFilter filter : intentFilters.value()) {
                convertedIntentFilters.add(this.convertIntentFilter(filter));
            }
        }
        org.androidtransfuse.model.manifest.IntentFilter resultIntentFilter = null;
        if (intentFilter != null) {
            resultIntentFilter = this.convertIntentFilter(intentFilter);
            convertedIntentFilters.add(resultIntentFilter);
        }
        if (intent != null) {
            if (resultIntentFilter == null) {
                resultIntentFilter = (org.androidtransfuse.model.manifest.IntentFilter)this.intentFilterProvider.get();
                convertedIntentFilters.add(resultIntentFilter);
            }
            this.addIntent(intent, resultIntentFilter);
        }
        return convertedIntentFilters;
    }

    private org.androidtransfuse.model.manifest.IntentFilter convertIntentFilter(IntentFilter intentFilter) {
        org.androidtransfuse.model.manifest.IntentFilter resultIntentFilter = (org.androidtransfuse.model.manifest.IntentFilter)this.intentFilterProvider.get();
        resultIntentFilter.setIcon(AnnotationUtil.checkBlank((String)intentFilter.icon()));
        resultIntentFilter.setLabel(AnnotationUtil.checkBlank((String)intentFilter.label()));
        resultIntentFilter.setPriority((Integer)AnnotationUtil.checkDefault((Object)intentFilter.priority(), (Object)-1));
        for (Intent intentAnnotation : intentFilter.value()) {
            this.addIntent(intentAnnotation, resultIntentFilter);
        }
        return resultIntentFilter;
    }

    private void addIntent(Intent intentAnnotation, org.androidtransfuse.model.manifest.IntentFilter intentFilter) {
        switch (intentAnnotation.type()) {
            case ACTION: {
                Action action = (Action)this.actionProvider.get();
                action.setName(intentAnnotation.name());
                intentFilter.getActions().add(action);
                break;
            }
            case CATEGORY: {
                Category category = (Category)this.categoryProvider.get();
                category.setName(intentAnnotation.name());
                intentFilter.getCategories().add(category);
                break;
            }
        }
    }
}

