/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.annotations.Parcel;
import org.androidtransfuse.annotations.Transient;
import org.androidtransfuse.model.GetterSetterMethodPair;
import org.androidtransfuse.model.ParcelableDescriptor;
import org.androidtransfuse.validation.Validator;

public class ParcelableAnalysis
implements Analysis<ParcelableDescriptor> {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final String[] PREPENDS = new String[]{"get", "is", "set"};
    private final Map<ASTType, ParcelableDescriptor> parcelableCache = new HashMap<ASTType, ParcelableDescriptor>();
    private final ASTClassFactory astClassFactory;
    private final Validator validator;

    @Inject
    public ParcelableAnalysis(ASTClassFactory astClassFactory, Validator validator) {
        this.astClassFactory = astClassFactory;
        this.validator = validator;
    }

    @Override
    public ParcelableDescriptor analyze(ASTType astType) {
        if (!this.parcelableCache.containsKey(astType)) {
            ParcelableDescriptor parcelableDescriptor = this.innerAnalyze(astType);
            this.parcelableCache.put(astType, parcelableDescriptor);
            this.analyzeDependencies(parcelableDescriptor.getGetterSetterPairs());
        }
        return this.parcelableCache.get(astType);
    }

    private void analyzeDependencies(List<GetterSetterMethodPair> propertyPairs) {
        for (GetterSetterMethodPair propertyPair : propertyPairs) {
            ASTType type = propertyPair.getGetter().getReturnType();
            if (!type.isAnnotated(Parcel.class)) continue;
            this.analyze(type);
        }
    }

    private ParcelableDescriptor innerAnalyze(ASTType astType) {
        ParcelableDescriptor parcelableDescriptor;
        if (this.converterDefined(astType)) {
            parcelableDescriptor = new ParcelableDescriptor(this.getConverterType(astType));
        } else {
            HashMap<String, ASTMethod> methodNameMap = new HashMap<String, ASTMethod>();
            parcelableDescriptor = new ParcelableDescriptor();
            for (ASTMethod astMethod : astType.getMethods()) {
                methodNameMap.put(astMethod.getName(), astMethod);
            }
            for (ASTMethod astMethod : astType.getMethods()) {
                String setterName;
                ASTMethod setterMethod;
                if (astMethod.isAnnotated(Transient.class) || !this.isGetter(astMethod) || (setterMethod = (ASTMethod)methodNameMap.get(setterName = SET + astMethod.getName().substring(GET.length()))) == null || setterMethod.isAnnotated(Transient.class)) continue;
                if (setterMethod.getParameters().size() > 1) {
                    this.validator.error("Setter has too few parameters.").element((ASTBase)astMethod).build();
                    continue;
                }
                if (setterMethod.getParameters().size() > 1) {
                    this.validator.error("Setter has too many parameters.").element((ASTBase)astMethod).build();
                    continue;
                }
                if (!((ASTParameter)setterMethod.getParameters().get(0)).getASTType().equals(astMethod.getReturnType())) {
                    this.validator.error("Setter parameter does not match corresponding Getter return type").element((ASTBase)astMethod).build();
                    continue;
                }
                parcelableDescriptor.getGetterSetterPairs().add(new GetterSetterMethodPair(this.getPropertyName(astMethod), astMethod, setterMethod));
            }
        }
        return parcelableDescriptor;
    }

    private boolean converterDefined(ASTType astType) {
        ASTType converterType = this.getConverterType(astType);
        ASTType emptyConverterType = this.astClassFactory.getType(Parcel.EmptyConverter.class);
        return converterType != null && !converterType.equals(emptyConverterType);
    }

    private ASTType getConverterType(ASTType astType) {
        ASTAnnotation astAnnotation = astType.getASTAnnotation(Parcel.class);
        return (ASTType)astAnnotation.getProperty("value", ASTType.class);
    }

    private boolean isGetter(ASTMethod astMethod) {
        boolean isGetter;
        boolean bl = isGetter = astMethod.getParameters().size() == 0 && (astMethod.getName().startsWith(GET) || astMethod.getName().startsWith(IS));
        if (isGetter && astMethod.getReturnType().equals(ASTVoidType.VOID)) {
            this.validator.error("Bean setter in parcel must not return void.").element((ASTBase)astMethod).build();
        }
        return isGetter;
    }

    private String getPropertyName(ASTMethod astMethod) {
        String methodName = astMethod.getName();
        for (String prepend : PREPENDS) {
            if (!methodName.startsWith(prepend)) continue;
            String name = methodName.substring(prepend.length());
            return name.substring(0, 1).toLowerCase(Locale.getDefault()) + name.substring(1);
        }
        throw new TransfuseAnalysisException("Unable to convert Method name " + methodName);
    }
}

