/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis;

import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.IntentFilterFactory;
import org.androidtransfuse.analysis.MetaDataBuilder;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.annotations.OnConfigurationChanged;
import org.androidtransfuse.annotations.OnCreate;
import org.androidtransfuse.annotations.OnDestroy;
import org.androidtransfuse.annotations.OnLowMemory;
import org.androidtransfuse.annotations.OnRebind;
import org.androidtransfuse.gen.GeneratorFactory;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ContextScopeComponentBuilder;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.componentBuilder.ListenerRegistrationGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodCallbackGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodGenerator;
import org.androidtransfuse.gen.componentBuilder.NoOpLayoutBuilder;
import org.androidtransfuse.gen.componentBuilder.ObservesRegistrationGenerator;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;
import org.androidtransfuse.intentFactory.ServiceIntentFactoryStrategy;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.processor.ManifestManager;
import org.androidtransfuse.scope.ContextScopeHolder;
import org.androidtransfuse.util.AnnotationUtil;
import org.androidtransfuse.util.TypeMirrorRunnable;
import org.androidtransfuse.util.TypeMirrorUtil;
import org.apache.commons.lang.StringUtils;

public class ServiceAnalysis
implements Analysis<ComponentDescriptor> {
    private final Provider<InjectionNodeBuilderRepository> injectionNodeRepositoryProvider;
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory;
    private final Provider<org.androidtransfuse.model.manifest.Service> manifestServiceProvider;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final AnalysisContextFactory analysisContextFactory;
    private final ASTClassFactory astClassFactory;
    private final ManifestManager manifestManager;
    private final IntentFilterFactory intentFilterBuilder;
    private final MetaDataBuilder metadataBuilder;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final ContextScopeComponentBuilder contextScopeComponentBuilder;
    private final GeneratorFactory generatorFactory;
    private final ListenerRegistrationGenerator listenerRegistrationGenerator;
    private final ObservesRegistrationGenerator observesExpressionDecorator;

    @Inject
    public ServiceAnalysis(Provider<InjectionNodeBuilderRepository> injectionNodeRepositoryProvider, InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory, Provider<org.androidtransfuse.model.manifest.Service> manifestServiceProvider, ComponentBuilderFactory componentBuilderFactory, AnalysisContextFactory analysisContextFactory, ASTClassFactory astClassFactory, ManifestManager manifestManager, IntentFilterFactory intentFilterBuilder, MetaDataBuilder metadataBuilder, InjectionBindingBuilder injectionBindingBuilder, ASTTypeBuilderVisitor astTypeBuilderVisitor, ContextScopeComponentBuilder contextScopeComponentBuilder, GeneratorFactory generatorFactory, ListenerRegistrationGenerator listenerRegistrationGenerator, ObservesRegistrationGenerator observesExpressionDecorator) {
        this.injectionNodeRepositoryProvider = injectionNodeRepositoryProvider;
        this.injectionNodeBuilderRepositoryFactory = injectionNodeBuilderRepositoryFactory;
        this.manifestServiceProvider = manifestServiceProvider;
        this.componentBuilderFactory = componentBuilderFactory;
        this.analysisContextFactory = analysisContextFactory;
        this.astClassFactory = astClassFactory;
        this.manifestManager = manifestManager;
        this.intentFilterBuilder = intentFilterBuilder;
        this.metadataBuilder = metadataBuilder;
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.contextScopeComponentBuilder = contextScopeComponentBuilder;
        this.generatorFactory = generatorFactory;
        this.listenerRegistrationGenerator = listenerRegistrationGenerator;
        this.observesExpressionDecorator = observesExpressionDecorator;
    }

    @Override
    public ComponentDescriptor analyze(ASTType input) {
        PackageClass serviceClassName;
        org.androidtransfuse.annotations.Service serviceAnnotation = (org.androidtransfuse.annotations.Service)input.getAnnotation(org.androidtransfuse.annotations.Service.class);
        ComponentDescriptor activityDescriptor = null;
        if (input.extendsFrom(this.astClassFactory.getType(Service.class))) {
            PackageClass activityPackageClass = input.getPackageClass();
            serviceClassName = this.buildPackageClass(input, activityPackageClass.getClassName());
        } else {
            serviceClassName = this.buildPackageClass(input, serviceAnnotation.name());
            TypeMirror type = TypeMirrorUtil.getTypeMirror((Runnable)new ServiceTypeMirrorRunnable(serviceAnnotation));
            String serviceType = type == null ? Service.class.getName() : ((Object)type).toString();
            AnalysisContext context = this.analysisContextFactory.buildAnalysisContext(this.buildVariableBuilderMap(type));
            activityDescriptor = new ComponentDescriptor(serviceType, serviceClassName);
            this.setupServiceProfile(activityDescriptor, input, context);
        }
        this.setupManifest(serviceClassName.getFullyQualifiedName(), serviceAnnotation, input);
        return activityDescriptor;
    }

    private PackageClass buildPackageClass(ASTType input, String activityName) {
        PackageClass inputPackageClass = input.getPackageClass();
        if (StringUtils.isBlank((String)activityName)) {
            return inputPackageClass.append("Service");
        }
        return inputPackageClass.replaceName(activityName);
    }

    private void setupManifest(String name, org.androidtransfuse.annotations.Service serviceAnnotation, ASTType type) {
        org.androidtransfuse.model.manifest.Service manifestService = this.buildService(name, serviceAnnotation);
        manifestService.setIntentFilters(this.intentFilterBuilder.buildIntentFilters(type));
        manifestService.setMetaData(this.metadataBuilder.buildMetaData(type));
        this.manifestManager.addService(manifestService);
    }

    protected org.androidtransfuse.model.manifest.Service buildService(String name, org.androidtransfuse.annotations.Service serviceAnnotation) {
        org.androidtransfuse.model.manifest.Service manifestService = (org.androidtransfuse.model.manifest.Service)this.manifestServiceProvider.get();
        manifestService.setName(name);
        manifestService.setEnabled((Boolean)AnnotationUtil.checkDefault((Object)serviceAnnotation.enabled(), (Object)true));
        manifestService.setExported((Boolean)AnnotationUtil.checkDefault((Object)serviceAnnotation.exported(), (Object)true));
        manifestService.setIcon(AnnotationUtil.checkBlank((String)serviceAnnotation.icon()));
        manifestService.setLabel(AnnotationUtil.checkBlank((String)serviceAnnotation.label()));
        manifestService.setPermission(AnnotationUtil.checkBlank((String)serviceAnnotation.permission()));
        manifestService.setProcess(AnnotationUtil.checkBlank((String)serviceAnnotation.process()));
        return manifestService;
    }

    private void setupServiceProfile(ComponentDescriptor serviceDescriptor, ASTType astType, AnalysisContext context) {
        ASTMethod onCreateASTMethod = this.getASTMethod("onCreate", new Class[0]);
        serviceDescriptor.setInitMethodBuilder(this.astClassFactory.getType(OnCreate.class), this.componentBuilderFactory.buildOnCreateMethodBuilder(onCreateASTMethod, new NoOpLayoutBuilder()));
        serviceDescriptor.setInjectionNodeFactory((InjectionNodeFactory)this.componentBuilderFactory.buildInjectionNodeFactory((ImmutableSet<ASTAnnotation>)ImmutableSet.of(), astType, context));
        serviceDescriptor.addGenerators(this.buildEventMethod(OnConfigurationChanged.class, "onConfigurationChanged", Configuration.class));
        serviceDescriptor.addGenerators(this.buildEventMethod(OnDestroy.class, "onDestroy", new Class[0]));
        serviceDescriptor.addGenerators(this.buildEventMethod(OnLowMemory.class, "onLowMemory", new Class[0]));
        serviceDescriptor.addGenerators(this.buildEventMethod(OnRebind.class, "onRebind", Intent.class));
        serviceDescriptor.addGenerators(new OnBindGenerator());
        serviceDescriptor.addGenerators(this.listenerRegistrationGenerator);
        serviceDescriptor.addGenerators(this.contextScopeComponentBuilder);
        serviceDescriptor.addRegistration(this.observesExpressionDecorator);
        serviceDescriptor.getGenerators().add(this.generatorFactory.buildStrategyGenerator(ServiceIntentFactoryStrategy.class));
    }

    private MethodCallbackGenerator buildEventMethod(Class<? extends Annotation> eventAnnotationClass, String methodName, Class ... args) {
        ASTMethod method = this.getASTMethod(methodName, args);
        ASTType eventAnnotation = this.astClassFactory.getType(eventAnnotationClass);
        return this.componentBuilderFactory.buildMethodCallbackGenerator(eventAnnotation, (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(method, true));
    }

    private ASTMethod getASTMethod(String methodName, Class ... args) {
        return this.getASTMethod(Service.class, methodName, args);
    }

    private ASTMethod getASTMethod(Class type, String methodName, Class ... args) {
        try {
            return this.astClassFactory.getMethod(type.getDeclaredMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while trying to reference method " + methodName, (Throwable)e);
        }
    }

    private InjectionNodeBuilderRepository buildVariableBuilderMap(TypeMirror type) {
        InjectionNodeBuilderRepository injectionNodeBuilderRepository = (InjectionNodeBuilderRepository)this.injectionNodeRepositoryProvider.get();
        injectionNodeBuilderRepository.putType(Context.class, this.injectionBindingBuilder.buildThis(Context.class));
        injectionNodeBuilderRepository.putType(Application.class, this.injectionBindingBuilder.dependency(Context.class).invoke(Application.class, "getApplication").build());
        injectionNodeBuilderRepository.putType(Service.class, this.injectionBindingBuilder.buildThis(Service.class));
        injectionNodeBuilderRepository.putType(ContextScopeHolder.class, this.injectionBindingBuilder.buildThis(ContextScopeHolder.class));
        if (type != null && !((Object)type).toString().equals(Service.class.getName())) {
            ASTType serviceASTType = (ASTType)type.accept(this.astTypeBuilderVisitor, null);
            injectionNodeBuilderRepository.putType(serviceASTType, this.injectionBindingBuilder.buildThis(serviceASTType));
        }
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildApplicationInjections());
        injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildModuleConfiguration());
        return injectionNodeBuilderRepository;
    }

    private static class OnBindGenerator
    implements ExpressionVariableDependentGenerator {
        private OnBindGenerator() {
        }

        @Override
        public void generate(JDefinedClass definedClass, MethodDescriptor methodDescriptor, Map<InjectionNode, TypedExpression> expressionMap, ComponentDescriptor descriptor, JExpression scopesExpression) {
            JMethod onBind = definedClass.method(1, IBinder.class, "onBind");
            onBind.annotate(Override.class);
            onBind.param(Intent.class, "intent");
            onBind.body()._return(JExpr._null());
        }
    }

    private static class ServiceTypeMirrorRunnable
    extends TypeMirrorRunnable<org.androidtransfuse.annotations.Service> {
        public ServiceTypeMirrorRunnable(org.androidtransfuse.annotations.Service serviceAnnotation) {
            super(serviceAnnotation);
        }

        @Override
        public void run(org.androidtransfuse.annotations.Service annotation) {
            annotation.type();
        }
    }
}

