/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysis;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidator;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidatorBuilder;
import org.androidtransfuse.annotations.Activity;
import org.androidtransfuse.annotations.Application;
import org.androidtransfuse.annotations.Bind;
import org.androidtransfuse.annotations.BindInterceptor;
import org.androidtransfuse.annotations.BindInterceptors;
import org.androidtransfuse.annotations.BindProvider;
import org.androidtransfuse.annotations.BindProviders;
import org.androidtransfuse.annotations.Bindings;
import org.androidtransfuse.annotations.BroadcastReceiver;
import org.androidtransfuse.annotations.DefineScope;
import org.androidtransfuse.annotations.DefineScopes;
import org.androidtransfuse.annotations.Extra;
import org.androidtransfuse.annotations.Fragment;
import org.androidtransfuse.annotations.Layout;
import org.androidtransfuse.annotations.LayoutHandler;
import org.androidtransfuse.annotations.MetaData;
import org.androidtransfuse.annotations.MetaDataSet;
import org.androidtransfuse.annotations.Preference;
import org.androidtransfuse.annotations.Provides;
import org.androidtransfuse.annotations.Resource;
import org.androidtransfuse.annotations.Service;
import org.androidtransfuse.annotations.SystemService;
import org.androidtransfuse.annotations.TransfuseModule;
import org.androidtransfuse.annotations.UsesPermission;
import org.androidtransfuse.annotations.UsesSdk;
import org.androidtransfuse.annotations.View;
import org.androidtransfuse.model.InjectionNode;

public class AnnotationValidationAnalysis
implements ASTAnalysis {
    private final AnnotationValidator annotationValidator;

    @Inject
    public AnnotationValidationAnalysis(AnnotationValidatorBuilder builder) {
        builder.given(Extra.class).requires(Inject.class, "@Extra annotation must be accompanied by @Inject");
        builder.given(Extra.class).parameterMatches("value", "^[a-zA-Z][a-zA-Z0-9_]*$", "@Extra value parameter must follow Java Bean syntax");
        builder.given(View.class).requires(Inject.class, "@View annotation must be accompanied by @Inject");
        builder.given(Preference.class).requires(Inject.class, "@Preference annotation must be accompanied by @Inject");
        builder.given(Resource.class).requires(Inject.class, "@Resource annotation must be accompanied by @Inject");
        builder.given(SystemService.class).requires(Inject.class, "@SystemService annotation must be accompanied by @Inject");
        builder.given(Layout.class).requires(Arrays.asList(Activity.class, Fragment.class), "@Layout annotation must be accompanied by @Activity");
        builder.given(LayoutHandler.class).requires(Arrays.asList(Activity.class, Fragment.class), "@LayoutHandler annotation must be accompanied by @Activity");
        builder.given(MetaData.class).requires(Activity.class, "@MetaData annotation must be accompanied by @Activity");
        builder.given(MetaDataSet.class).requires(Activity.class, "@MetaDataSet annotation must be accompanied by @Activity");
        builder.given(Activity.class).parameterMatches("name", "^[a-zA-Z][a-zA-Z0-9_]*$", "@Activity name parameter must follow Java Bean syntax");
        builder.given(Service.class).parameterMatches("name", "^[a-zA-Z][a-zA-Z0-9_]*$", "@Service name parameter must follow Java Bean syntax");
        builder.given(Fragment.class).parameterMatches("name", "^[a-zA-Z][a-zA-Z0-9_]*$", "@Fragment name parameter must follow Java Bean syntax");
        builder.given(BroadcastReceiver.class).parameterMatches("name", "^[a-zA-Z][a-zA-Z0-9_]*$", "@BroadcastReceiver name parameter must follow Java Bean syntax");
        builder.given(Application.class).parameterMatches("name", "^[a-zA-Z][a-zA-Z0-9_]*$", "@Application name parameter must follow Java Bean syntax");
        builder.given(Bind.class).requires(TransfuseModule.class, "@Bind annotation must be accompanied by @TransfuseModule");
        builder.given(Bindings.class).requires(TransfuseModule.class, "@Bindings annotation must be accompanied by @TransfuseModule");
        builder.given(BindInterceptor.class).requires(TransfuseModule.class, "@BindInterceptor annotation must be accompanied by @TransfuseModule");
        builder.given(BindInterceptors.class).requires(TransfuseModule.class, "@BindInterceptors annotation must be accompanied by @TransfuseModule");
        builder.given(BindProvider.class).requires(TransfuseModule.class, "@BindProvider annotation must be accompanied by @TransfuseModule");
        builder.given(BindProviders.class).requires(TransfuseModule.class, "@BindProviders annotation must be accompanied by @TransfuseModule");
        builder.given(DefineScope.class).requires(TransfuseModule.class, "@DefineScope annotation must be accompanied by @TransfuseModule");
        builder.given(DefineScopes.class).requires(TransfuseModule.class, "@DefineScopes annotation must be accompanied by @TransfuseModule");
        builder.given(UsesPermission.class).requires(TransfuseModule.class, "@UsesPermission annotation must be accompanied by @TransfuseModule");
        builder.given(UsesSdk.class).requires(TransfuseModule.class, "@UsesSdk annotation must be accompanied by @TransfuseModule");
        builder.given(Provides.class).requires(TransfuseModule.class, "@Provides annotation must be accompanied by @TransfuseModule");
        this.annotationValidator = builder.build();
    }

    public void analyzeType(InjectionNode injectionNode, ASTType astType, AnalysisContext context) {
        for (ASTAnnotation annotation : astType.getAnnotations()) {
            this.validateAnnotation(annotation, (ASTBase)astType, astType.getAnnotations());
        }
        for (ASTConstructor astConstructor : astType.getConstructors()) {
            for (ASTAnnotation annotation : astConstructor.getAnnotations()) {
                this.validateAnnotation(annotation, (ASTBase)astConstructor, astConstructor.getAnnotations(), astType.getAnnotations());
                for (ASTParameter astParameter : astConstructor.getParameters()) {
                    this.validateParameter(astParameter, (ASTBase)astConstructor, astType);
                }
            }
        }
    }

    public void analyzeMethod(InjectionNode injectionNode, ASTType concreteType, ASTMethod astMethod, AnalysisContext context) {
        for (ASTAnnotation annotation : astMethod.getAnnotations()) {
            this.validateAnnotation(annotation, (ASTBase)astMethod, astMethod.getAnnotations(), concreteType.getAnnotations());
            for (ASTParameter astParameter : astMethod.getParameters()) {
                this.validateParameter(astParameter, (ASTBase)astMethod, concreteType);
            }
        }
    }

    public void analyzeField(InjectionNode injectionNode, ASTType concreteType, ASTField astField, AnalysisContext context) {
        for (ASTAnnotation annotation : astField.getAnnotations()) {
            this.validateAnnotation(annotation, (ASTBase)astField, astField.getAnnotations(), concreteType.getAnnotations());
        }
    }

    private void validateParameter(ASTParameter parameter, ASTBase containingAST, ASTType containingType) {
        for (ASTAnnotation paramAnnotation : parameter.getAnnotations()) {
            this.validateAnnotation(paramAnnotation, (ASTBase)parameter, parameter.getAnnotations(), containingAST.getAnnotations(), containingType.getAnnotations());
        }
    }

    private void validateAnnotation(ASTAnnotation annotation, ASTBase astBase, ImmutableSet<ASTAnnotation> ... applicableAnnotations) {
        this.annotationValidator.validate(annotation, astBase, this.flatten(applicableAnnotations));
    }

    private ImmutableSet<ASTAnnotation> flatten(ImmutableSet<ASTAnnotation> ... sets) {
        ImmutableSet.Builder combineBuilder = ImmutableSet.builder();
        for (ImmutableSet<ASTAnnotation> set : sets) {
            combineBuilder.addAll(set);
        }
        return combineBuilder.build();
    }
}

