/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysisAdaptor;
import org.androidtransfuse.analysis.astAnalyzer.ASTInjectionAspect;
import org.androidtransfuse.analysis.astAnalyzer.ListenerAspect;
import org.androidtransfuse.annotations.EventListener;
import org.androidtransfuse.model.InjectionNode;

public class ListenerAnalysis
extends ASTAnalysisAdaptor {
    public void analyzeMethod(InjectionNode injectionNode, ASTType concreteType, ASTMethod astMethod, AnalysisContext context) {
        for (ASTAnnotation annotation : astMethod.getAnnotations()) {
            ASTType annotationType = annotation.getASTType();
            if (!annotationType.isAnnotated(EventListener.class)) continue;
            this.addMethod(injectionNode, annotationType, astMethod);
        }
    }

    private void addMethod(InjectionNode injectionNode, ASTType annotation, ASTMethod astMethod) {
        if (!injectionNode.containsAspect(ListenerAspect.class)) {
            injectionNode.addAspect((Object)new ListenerAspect());
        }
        ListenerAspect methodCallbackToken = (ListenerAspect)injectionNode.getAspect(ListenerAspect.class);
        methodCallbackToken.addMethodCallback(annotation, astMethod);
        ASTInjectionAspect injectionAspect = (ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class);
        if (injectionAspect == null) {
            injectionAspect = new ASTInjectionAspect();
            injectionNode.addAspect(ASTInjectionAspect.class, (Object)injectionAspect);
        }
        injectionAspect.setAssignmentType(ASTInjectionAspect.InjectionAssignmentType.FIELD);
    }
}

