/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysisAdaptor;
import org.androidtransfuse.analysis.astAnalyzer.ASTInjectionAspect;
import org.androidtransfuse.analysis.astAnalyzer.NonConfigurationAspect;
import org.androidtransfuse.annotations.NonConfigurationInstance;
import org.androidtransfuse.model.InjectionNode;

public class NonConfigurationAnalysis
extends ASTAnalysisAdaptor {
    private final InjectionPointFactory injectionPointFactory;

    @Inject
    public NonConfigurationAnalysis(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public void analyzeField(InjectionNode injectionNode, ASTType concreteType, ASTField astField, AnalysisContext context) {
        if (astField.isAnnotated(NonConfigurationInstance.class)) {
            NonConfigurationAspect aspect = this.buildAspect(injectionNode);
            aspect.add(this.injectionPointFactory.buildInjectionPoint(concreteType, astField, context));
            if (!injectionNode.containsAspect(ASTInjectionAspect.class)) {
                injectionNode.addAspect(ASTInjectionAspect.class, (Object)new ASTInjectionAspect());
            }
            ((ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class)).setAssignmentType(ASTInjectionAspect.InjectionAssignmentType.FIELD);
        }
    }

    private NonConfigurationAspect buildAspect(InjectionNode injectionNode) {
        if (!injectionNode.containsAspect(NonConfigurationAspect.class)) {
            injectionNode.addAspect((Object)new NonConfigurationAspect());
        }
        return (NonConfigurationAspect)injectionNode.getAspect(NonConfigurationAspect.class);
    }
}

