/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysisAdaptor;
import org.androidtransfuse.analysis.astAnalyzer.ObservesAspect;
import org.androidtransfuse.annotations.Observes;
import org.androidtransfuse.event.EventTending;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.validation.Validator;

public class ObservesAnalysis
extends ASTAnalysisAdaptor {
    private final Analyzer analyzer;
    private final ASTClassFactory astClassFactory;
    private final Validator validator;

    @Inject
    public ObservesAnalysis(Analyzer analyzer, ASTClassFactory astClassFactory, Validator validator) {
        this.analyzer = analyzer;
        this.astClassFactory = astClassFactory;
        this.validator = validator;
    }

    public void analyzeMethod(InjectionNode injectionNode, ASTType concreteType, ASTMethod astMethod, AnalysisContext context) {
        ASTParameter firstParameter = null;
        if (astMethod.getParameters().size() > 0) {
            firstParameter = (ASTParameter)astMethod.getParameters().get(0);
        }
        for (int i = 1; i < astMethod.getParameters().size(); ++i) {
            if (!((ASTParameter)astMethod.getParameters().get(i)).isAnnotated(Observes.class)) continue;
            this.validator.error("@Observes methods must annotate either the method or first method parameter").element((ASTBase)astMethod.getParameters().get(i)).build();
            throw new TransfuseAnalysisException("Malformed event Observer found on " + astMethod.getName());
        }
        if (firstParameter != null && (firstParameter.isAnnotated(Observes.class) || astMethod.isAnnotated(Observes.class))) {
            if (astMethod.getParameters().size() != 1) {
                this.validator.error("@Observes methods must contain one and only one event parameter").element((ASTBase)astMethod).build();
                throw new TransfuseAnalysisException("Malformed event Observer found on " + astMethod.getName());
            }
            if (!injectionNode.containsAspect(ObservesAspect.class)) {
                ASTType observerTestingASType = this.astClassFactory.getType(EventTending.class);
                InjectionNode observerTendingInjectionNode = this.analyzer.analyze(observerTestingASType, observerTestingASType, context);
                injectionNode.addAspect((Object)new ObservesAspect(observerTendingInjectionNode));
            }
            ObservesAspect aspect = (ObservesAspect)injectionNode.getAspect(ObservesAspect.class);
            aspect.addObserver(firstParameter.getASTType(), astMethod);
        }
    }
}

