/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTMethodUniqueSignatureDecorator;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.model.InjectionNode;

public class ObservesAspect {
    private final Map<ASTType, Set<ASTMethod>> observesMap = new HashMap<ASTType, Set<ASTMethod>>();
    private final InjectionNode observerTendingInjectionNode;

    public ObservesAspect(InjectionNode observerTendingInjectionNode) {
        this.observerTendingInjectionNode = observerTendingInjectionNode;
    }

    public void addObserver(ASTType event, ASTMethod method) {
        if (!this.observesMap.containsKey(event)) {
            this.observesMap.put(event, new HashSet());
        }
        this.observesMap.get(event).add((ASTMethod)new ASTMethodUniqueSignatureDecorator(method));
    }

    public Set<ASTType> getEvents() {
        return this.observesMap.keySet();
    }

    public Set<ASTMethod> getObserverMethods(ASTType event) {
        if (this.observesMap.containsKey(event)) {
            return this.observesMap.get(event);
        }
        return Collections.emptySet();
    }

    public InjectionNode getObserverTendingInjectionNode() {
        return this.observerTendingInjectionNode;
    }
}

