/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer;

import android.view.View;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysis;
import org.androidtransfuse.analysis.astAnalyzer.ASTInjectionAspect;
import org.androidtransfuse.analysis.astAnalyzer.RegistrationAspect;
import org.androidtransfuse.annotations.RegisterListener;
import org.androidtransfuse.annotations.View;
import org.androidtransfuse.gen.componentBuilder.ActivityDelegateASTReference;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.RegistrationGenerator;
import org.androidtransfuse.gen.componentBuilder.ViewRegistrationInvocationBuilder;
import org.androidtransfuse.gen.componentBuilder.ViewTypeRegistrationInvocationBuilderImpl;
import org.androidtransfuse.listeners.ActivityMenuComponent;
import org.androidtransfuse.listeners.ActivityOnKeyDownListener;
import org.androidtransfuse.listeners.ActivityOnKeyLongPressListener;
import org.androidtransfuse.listeners.ActivityOnKeyMultipleListener;
import org.androidtransfuse.listeners.ActivityOnKeyUpListener;
import org.androidtransfuse.listeners.ActivityOnTouchEventListener;
import org.androidtransfuse.listeners.ActivityOnTrackballEventListener;
import org.androidtransfuse.listeners.CallThrough;
import org.androidtransfuse.listeners.ServiceOnStartCommand;
import org.androidtransfuse.listeners.ServiceOnUnbind;
import org.androidtransfuse.model.InjectionNode;

public class RegistrationAnalyzer
implements ASTAnalysis {
    private final ImmutableMap<ASTType, RegistrationGeneratorFactory> generatorFactories;
    private final ASTClassFactory astClassFactory;
    private final InjectionPointFactory injectionPointFactory;
    private final ComponentBuilderFactory componentBuilderFactory;

    @Inject
    public RegistrationAnalyzer(ASTClassFactory astClassFactory, InjectionPointFactory injectionPointFactory, ComponentBuilderFactory componentBuilderFactory) {
        this.astClassFactory = astClassFactory;
        this.injectionPointFactory = injectionPointFactory;
        this.componentBuilderFactory = componentBuilderFactory;
        HashMap<ASTType, String> listenerMethodMapping = new HashMap<ASTType, String>();
        listenerMethodMapping.put(this.astType(View.OnClickListener.class), "setOnClickListener");
        listenerMethodMapping.put(this.astType(View.OnLongClickListener.class), "setOnLongClickListener");
        listenerMethodMapping.put(this.astType(View.OnCreateContextMenuListener.class), "setOnCreateContextMenuListener");
        listenerMethodMapping.put(this.astType(View.OnKeyListener.class), "setOnKeyListener");
        listenerMethodMapping.put(this.astType(View.OnTouchListener.class), "setOnTouchListener");
        listenerMethodMapping.put(this.astType(View.OnFocusChangeListener.class), "setOnFocusChangeListener");
        HashSet<ASTType> callThroughMapping = new HashSet<ASTType>();
        callThroughMapping.add(this.astType(ActivityOnKeyDownListener.class));
        callThroughMapping.add(this.astType(ActivityOnKeyLongPressListener.class));
        callThroughMapping.add(this.astType(ActivityOnKeyUpListener.class));
        callThroughMapping.add(this.astType(ActivityOnKeyMultipleListener.class));
        callThroughMapping.add(this.astType(ActivityOnTouchEventListener.class));
        callThroughMapping.add(this.astType(ActivityOnTrackballEventListener.class));
        callThroughMapping.add(this.astType(ActivityMenuComponent.class));
        callThroughMapping.add(this.astType(ServiceOnStartCommand.class));
        callThroughMapping.add(this.astType(ServiceOnUnbind.class));
        ImmutableMap.Builder generatorBuilder = ImmutableMap.builder();
        generatorBuilder.putAll(Maps.transformValues(listenerMethodMapping, (Function)new ListenerMethodMappingTransformer()));
        generatorBuilder.putAll(Maps.transformValues((Map)Maps.uniqueIndex(callThroughMapping, (Function)Functions.identity()), (Function)new CallThroughMethodMappingFunction()));
        this.generatorFactories = generatorBuilder.build();
    }

    private ASTType astType(Class<?> clazz) {
        return this.astClassFactory.getType(clazz);
    }

    private RegistrationGeneratorFactory buildActivityDelegateRegistrationGeneratorFactory(ASTType listenerInterface) {
        ImmutableList.Builder delegateMethods = ImmutableList.builder();
        for (ASTMethod method : listenerInterface.getMethods()) {
            if (!method.isAnnotated(CallThrough.class)) continue;
            delegateMethods.add((Object)method);
        }
        return new ActivityDelegateRegistrationGeneratorFactory(delegateMethods.build());
    }

    public void analyzeType(InjectionNode injectionNode, ASTType astType, AnalysisContext context) {
        this.analyze((ASTBase)astType, astType, injectionNode, context);
    }

    public void analyzeMethod(InjectionNode injectionNode, ASTType concreteType, ASTMethod astMethod, AnalysisContext context) {
        this.analyze((ASTBase)astMethod, astMethod.getReturnType(), injectionNode, context);
    }

    public void analyzeField(InjectionNode injectionNode, ASTType concreteType, ASTField astField, AnalysisContext context) {
        this.analyze((ASTBase)astField, astField.getASTType(), injectionNode, context);
    }

    private <T> void analyze(ASTBase astBase, ASTType astType, InjectionNode injectionNode, AnalysisContext context) {
        if (astBase.isAnnotated(RegisterListener.class)) {
            ImmutableList<RegistrationGenerator> generators;
            ASTAnnotation registerAnnotation = astBase.getASTAnnotation(RegisterListener.class);
            ASTType[] interfaces = (ASTType[])registerAnnotation.getProperty("interfaces", ASTType[].class);
            ArrayList<ASTType> interfaceList = new ArrayList<ASTType>();
            if (interfaces != null) {
                interfaceList.addAll(Arrays.asList(interfaces));
            }
            if (!(generators = this.getGeneratorFactories(injectionNode, astBase, astType, interfaceList, registerAnnotation, context)).isEmpty()) {
                RegistrationAspect registrationAspect = this.getRegistrationAspect(injectionNode);
                registrationAspect.addRegistrationBuilders((List<RegistrationGenerator>)generators);
            }
        }
    }

    private ImmutableList<RegistrationGenerator> getGeneratorFactories(InjectionNode injectionNode, ASTBase astBase, ASTType astType, List<ASTType> interfaceList, ASTAnnotation registerAnnotation, AnalysisContext context) {
        ImmutableList.Builder generators = ImmutableList.builder();
        for (Map.Entry generatorFactoryEntry : this.generatorFactories.entrySet()) {
            if (!interfaceList.isEmpty() && !interfaceList.contains(generatorFactoryEntry.getKey()) || !astType.inheritsFrom((ASTType)generatorFactoryEntry.getKey())) continue;
            generators.add((Object)((RegistrationGeneratorFactory)generatorFactoryEntry.getValue()).buildRegistrationGenerator(injectionNode, astBase, registerAnnotation, context));
        }
        return generators.build();
    }

    private InjectionNode buildViewInjectionNode(ASTAnnotation registerAnnotation, AnalysisContext context) {
        ASTType viewType = this.astClassFactory.getType(android.view.View.class);
        ASTType atViewType = this.astClassFactory.getType(View.class);
        ASTAnnotationPropertyReplacement viewRegistrationAnnotation = new ASTAnnotationPropertyReplacement(registerAnnotation, atViewType);
        return this.injectionPointFactory.buildInjectionNode(Collections.singleton(viewRegistrationAnnotation), viewType, context);
    }

    private RegistrationAspect getRegistrationAspect(InjectionNode injectionNode) {
        if (!injectionNode.containsAspect(RegistrationAspect.class)) {
            injectionNode.addAspect((Object)new RegistrationAspect());
        }
        return (RegistrationAspect)injectionNode.getAspect(RegistrationAspect.class);
    }

    private static final class ASTAnnotationPropertyReplacement
    implements ASTAnnotation {
        private final ASTAnnotation annotation;
        private final ASTType astType;

        private ASTAnnotationPropertyReplacement(ASTAnnotation annotation, ASTType astType) {
            this.annotation = annotation;
            this.astType = astType;
        }

        public <T> T getProperty(String name, Class<T> type) {
            return (T)this.annotation.getProperty(name, type);
        }

        public ASTType getASTType() {
            return this.astType;
        }

        public ImmutableSet<String> getPropertyNames() {
            return this.annotation.getPropertyNames();
        }
    }

    private final class ActivityDelegateRegistrationGeneratorFactory
    implements RegistrationGeneratorFactory {
        private ImmutableList<ASTMethod> methods;

        private ActivityDelegateRegistrationGeneratorFactory(ImmutableList<ASTMethod> methods) {
            this.methods = methods;
        }

        @Override
        public RegistrationGenerator buildRegistrationGenerator(InjectionNode injectionNode, ASTBase astBase, ASTAnnotation registerAnnotation, AnalysisContext context) {
            ActivityDelegateASTReference delegateASTReference;
            if (astBase instanceof ASTType) {
                delegateASTReference = RegistrationAnalyzer.this.componentBuilderFactory.buildActivityTypeDelegateASTReference();
            } else if (astBase instanceof ASTMethod) {
                delegateASTReference = RegistrationAnalyzer.this.componentBuilderFactory.buildActivityMethodDelegateASTReference((ASTMethod)astBase);
            } else if (astBase instanceof ASTField) {
                delegateASTReference = RegistrationAnalyzer.this.componentBuilderFactory.buildActivityFieldDelegateASTReference((ASTField)astBase);
            } else {
                throw new TransfuseAnalysisException("ASTBase type not mapped");
            }
            if (!injectionNode.containsAspect(ASTInjectionAspect.class)) {
                injectionNode.addAspect((Object)new ASTInjectionAspect());
            }
            ((ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class)).setAssignmentType(ASTInjectionAspect.InjectionAssignmentType.FIELD);
            return RegistrationAnalyzer.this.componentBuilderFactory.buildActivityRegistrationGenerator(delegateASTReference, this.methods);
        }
    }

    private final class ViewRegistrationGeneratorFactory
    implements RegistrationGeneratorFactory {
        private String listenerMethod;

        private ViewRegistrationGeneratorFactory(String listenerMethod) {
            this.listenerMethod = listenerMethod;
        }

        @Override
        public RegistrationGenerator buildRegistrationGenerator(InjectionNode injectionNode, ASTBase astBase, ASTAnnotation registerAnnotation, AnalysisContext context) {
            ViewRegistrationInvocationBuilder invocationBuilder;
            InjectionNode viewInjectionNode = RegistrationAnalyzer.this.buildViewInjectionNode(registerAnnotation, context);
            if (astBase instanceof ASTType) {
                invocationBuilder = new ViewTypeRegistrationInvocationBuilderImpl();
            } else if (astBase instanceof ASTMethod) {
                invocationBuilder = RegistrationAnalyzer.this.componentBuilderFactory.buildViewMethodRegistrationInvocationBuilder((ASTMethod)astBase);
            } else if (astBase instanceof ASTField) {
                invocationBuilder = RegistrationAnalyzer.this.componentBuilderFactory.buildViewFieldRegistrationInvocationBuilder((ASTField)astBase);
            } else {
                throw new TransfuseAnalysisException("ASTBase type not mapped");
            }
            return RegistrationAnalyzer.this.componentBuilderFactory.buildViewRegistrationGenerator(viewInjectionNode, this.listenerMethod, injectionNode, invocationBuilder);
        }
    }

    private static interface RegistrationGeneratorFactory {
        public RegistrationGenerator buildRegistrationGenerator(InjectionNode var1, ASTBase var2, ASTAnnotation var3, AnalysisContext var4);
    }

    private final class CallThroughMethodMappingFunction
    implements Function<ASTType, RegistrationGeneratorFactory> {
        private CallThroughMethodMappingFunction() {
        }

        public RegistrationGeneratorFactory apply(ASTType astType) {
            return RegistrationAnalyzer.this.buildActivityDelegateRegistrationGeneratorFactory(astType);
        }
    }

    private final class ListenerMethodMappingTransformer
    implements Function<String, RegistrationGeneratorFactory> {
        private ListenerMethodMappingTransformer() {
        }

        public RegistrationGeneratorFactory apply(String value) {
            return new ViewRegistrationGeneratorFactory(value);
        }
    }
}

