/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer.validation;

import com.google.common.collect.ImmutableSet;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidator;
import org.androidtransfuse.validation.Validator;

public class AnnotationAccompaniesValidator
implements AnnotationValidator {
    private final Validator validator;
    private final ImmutableSet<ASTType> requiredAnnotations;
    private final String message;

    public AnnotationAccompaniesValidator(Validator validator, ImmutableSet<ASTType> requiredAnnotations, String message) {
        this.validator = validator;
        this.requiredAnnotations = requiredAnnotations;
        this.message = message;
    }

    @Override
    public void validate(ASTAnnotation annotation, ASTBase astBase, ImmutableSet<ASTAnnotation> applicableAnnotations) {
        boolean found = false;
        for (ASTAnnotation applicableAnnotation : applicableAnnotations) {
            if (!this.requiredAnnotations.contains((Object)applicableAnnotation.getASTType())) continue;
            found = true;
        }
        if (!found) {
            this.validator.error(this.message).element(astBase).annotation(annotation).build();
        }
    }
}

