/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer.validation;

import com.google.common.collect.ImmutableSet;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidator;
import org.androidtransfuse.validation.Validator;

public class AnnotationParameterRegexValidator
implements AnnotationValidator {
    private final String regex;
    private final String parameter;
    private final Validator validator;
    private final String message;

    public AnnotationParameterRegexValidator(String regex, String parameter, Validator validator, String message) {
        this.regex = regex;
        this.parameter = parameter;
        this.validator = validator;
        this.message = message;
    }

    @Override
    public void validate(ASTAnnotation annotation, ASTBase astBase, ImmutableSet<ASTAnnotation> applicableAnnotations) {
        String parameterValue = (String)annotation.getProperty(this.parameter, String.class);
        if (parameterValue != null && !parameterValue.matches(this.regex)) {
            this.validator.error(this.message).element(astBase).annotation(annotation).parameter(this.parameter).build();
        }
    }
}

