/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer.validation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationAccompaniesValidator;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationParameterRegexValidator;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidator;
import org.androidtransfuse.analysis.astAnalyzer.validation.MultiAnnotationValidator;
import org.androidtransfuse.validation.Validator;

public class AnnotationValidatorBuilder {
    private final ASTClassFactory astClassFactory;
    private final Validator validator;
    private final Map<ASTType, Set<GivenAnnotationValidationBuilder>> givenMap = new HashMap<ASTType, Set<GivenAnnotationValidationBuilder>>();

    @Inject
    public AnnotationValidatorBuilder(ASTClassFactory astClassFactory, Validator validator) {
        this.astClassFactory = astClassFactory;
        this.validator = validator;
    }

    public AnnotationValidator build() {
        ImmutableMap annotationValidators = ImmutableMap.copyOf((Map)Maps.transformValues(this.givenMap, (Function)new Function<Set<GivenAnnotationValidationBuilder>, Set<AnnotationValidator>>(){

            public Set<AnnotationValidator> apply(Set<GivenAnnotationValidationBuilder> input) {
                ImmutableSet.Builder validationSetBuilder = ImmutableSet.builder();
                for (GivenAnnotationValidationBuilder givenAnnotationValidationBuilder : input) {
                    validationSetBuilder.add((Object)givenAnnotationValidationBuilder.build());
                }
                return validationSetBuilder.build();
            }
        }));
        return new MultiAnnotationValidator((ImmutableMap<ASTType, Set<AnnotationValidator>>)annotationValidators);
    }

    public GivenAnnotationValidationBuilder given(Class<? extends Annotation> annotationClass) {
        ASTType type = this.astClassFactory.getType(annotationClass);
        if (!this.givenMap.containsKey(type)) {
            this.givenMap.put(type, new HashSet());
        }
        GivenAnnotationValidationBuilder builder = new GivenAnnotationValidationBuilder();
        this.givenMap.get(type).add(builder);
        return builder;
    }

    public class GivenAnnotationValidationBuilder {
        private AnnotationValidator annotationValidator;

        public AnnotationValidator build() {
            return this.annotationValidator;
        }

        public void requires(Class<? extends Annotation> annotationClass, String message) {
            this.requires(Arrays.asList(annotationClass), message);
        }

        public void requires(List<Class<? extends Annotation>> annotationClasses, String message) {
            ImmutableSet.Builder annotationTypes = ImmutableSet.builder();
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                annotationTypes.add((Object)AnnotationValidatorBuilder.this.astClassFactory.getType(annotationClass));
            }
            this.annotationValidator = new AnnotationAccompaniesValidator(AnnotationValidatorBuilder.this.validator, (ImmutableSet<ASTType>)annotationTypes.build(), message);
        }

        public void parameterMatches(String parameterName, String regex, String message) {
            this.annotationValidator = new AnnotationParameterRegexValidator(regex, parameterName, AnnotationValidatorBuilder.this.validator, message);
        }
    }
}

