/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.astAnalyzer.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.astAnalyzer.validation.AnnotationValidator;

public class MultiAnnotationValidator
implements AnnotationValidator {
    private final ImmutableMap<ASTType, Set<AnnotationValidator>> validatorMap;

    public MultiAnnotationValidator(ImmutableMap<ASTType, Set<AnnotationValidator>> validatorMap) {
        this.validatorMap = validatorMap;
    }

    @Override
    public void validate(ASTAnnotation annotation, ASTBase astBase, ImmutableSet<ASTAnnotation> applicableAnnotations) {
        if (this.validatorMap.containsKey((Object)annotation.getASTType())) {
            Set validators = (Set)this.validatorMap.get((Object)annotation.getASTType());
            for (AnnotationValidator validator : validators) {
                validator.validate(annotation, astBase, applicableAnnotations);
            }
        }
    }
}

