/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.module;

import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.module.ModuleConfiguration;
import org.androidtransfuse.analysis.module.TypeProcessor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;

public class BindInterceptorProcessor
implements TypeProcessor {
    public ModuleConfiguration process(ASTType moduleType, ASTAnnotation bindInterceptor) {
        ASTType annotation = (ASTType)bindInterceptor.getProperty("annotation", ASTType.class);
        ASTType interceptor = (ASTType)bindInterceptor.getProperty("interceptor", ASTType.class);
        return new InterceptorsConfiguration(annotation, interceptor);
    }

    private static final class InterceptorsConfiguration
    implements ModuleConfiguration {
        private final ASTType annotation;
        private final ASTType interceptor;

        private InterceptorsConfiguration(ASTType annotation, ASTType interceptor) {
            this.annotation = annotation;
            this.interceptor = interceptor;
        }

        public void setConfiguration(InjectionNodeBuilderRepository configurationRepository) {
            configurationRepository.putInterceptor(this.annotation, this.interceptor);
        }
    }
}

