/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.module;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.annotations.ImplementedBy;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.transaction.AbstractCompletionTransactionWorker;
import org.androidtransfuse.util.TypeMirrorRunnable;
import org.androidtransfuse.util.TypeMirrorUtil;
import org.androidtransfuse.validation.Validator;

public class ImplementedByTransactionWorker
extends AbstractCompletionTransactionWorker<Provider<ASTType>, Void> {
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilders;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;
    private final Validator validator;

    @Inject
    public ImplementedByTransactionWorker(InjectionNodeBuilderRepositoryFactory injectionNodeBuilders, VariableInjectionBuilderFactory variableInjectionBuilderFactory, ASTTypeBuilderVisitor astTypeBuilderVisitor, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider, Validator validator) {
        this.injectionNodeBuilders = injectionNodeBuilders;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        this.validator = validator;
    }

    public Void innerRun(Provider<ASTType> astTypeProvider) {
        ASTType astType = (ASTType)astTypeProvider.get();
        ImplementedBy annotation = (ImplementedBy)astType.getAnnotation(ImplementedBy.class);
        InjectionNodeBuilderRepository repository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        if (annotation != null) {
            TypeMirror implementedClass = TypeMirrorUtil.getTypeMirror((Runnable)new ImplementedByClassTypeMirrorRunnable(annotation));
            ASTType implAstType = (ASTType)implementedClass.accept(this.astTypeBuilderVisitor, null);
            if (!implAstType.inheritsFrom(astType)) {
                this.validator.error("@ImplementedBy must reference a subclass").element((ASTBase)astType).annotation(astType.getASTAnnotation(ImplementedBy.class)).parameter("value").build();
                throw new TransfuseAnalysisException("ImplementedBy configuration points to a class that doesn't inherit from the given base class");
            }
            repository.putType(astType, (InjectionNodeBuilder)this.variableInjectionBuilderFactory.buildVariableInjectionNodeBuilder(implAstType));
        }
        this.injectionNodeBuilders.addModuleRepository(repository);
        return null;
    }

    private static class ImplementedByClassTypeMirrorRunnable
    extends TypeMirrorRunnable<ImplementedBy> {
        protected ImplementedByClassTypeMirrorRunnable(ImplementedBy annotation) {
            super(annotation);
        }

        @Override
        public void run(ImplementedBy annotation) {
            annotation.value();
        }
    }
}

