/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.module.BindInterceptorProcessor;
import org.androidtransfuse.analysis.module.BindProcessor;
import org.androidtransfuse.analysis.module.BindProviderProcessor;
import org.androidtransfuse.analysis.module.BindingConfigurationFactory;
import org.androidtransfuse.analysis.module.DefineScopeProcessor;
import org.androidtransfuse.analysis.module.MethodProcessor;
import org.androidtransfuse.analysis.module.ModuleConfiguration;
import org.androidtransfuse.analysis.module.ModuleRepository;
import org.androidtransfuse.analysis.module.ProvidesProcessor;
import org.androidtransfuse.analysis.module.TypeProcessor;
import org.androidtransfuse.analysis.module.UsesPermissionProcessor;
import org.androidtransfuse.analysis.module.UsesSdkProcessor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.annotations.Bind;
import org.androidtransfuse.annotations.BindInterceptor;
import org.androidtransfuse.annotations.BindInterceptors;
import org.androidtransfuse.annotations.BindProvider;
import org.androidtransfuse.annotations.BindProviders;
import org.androidtransfuse.annotations.Bindings;
import org.androidtransfuse.annotations.DefineScope;
import org.androidtransfuse.annotations.DefineScopes;
import org.androidtransfuse.annotations.Provides;
import org.androidtransfuse.annotations.UsesPermission;
import org.androidtransfuse.annotations.UsesSdk;
import org.androidtransfuse.transaction.AbstractCompletionTransactionWorker;

public class ModuleTransactionWorker
extends AbstractCompletionTransactionWorker<Provider<ASTType>, Void> {
    private final ImmutableMap<ASTType, MethodProcessor> methodProcessors;
    private final ImmutableMap<ASTType, TypeProcessor> typeProcessors;
    private final ModuleRepository moduleRepository;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;

    @Inject
    public ModuleTransactionWorker(BindProcessor bindProcessor, BindProviderProcessor bindProviderProcessor, BindInterceptorProcessor bindInterceptorProcessor, BindingConfigurationFactory configurationFactory, ProvidesProcessor providesProcessor, ASTClassFactory astClassFactory, UsesPermissionProcessor usesPermissionProcessor, UsesSdkProcessor usesSdkProcessor, DefineScopeProcessor defineScopeProcessor, ModuleRepository moduleRepository, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider) {
        this.moduleRepository = moduleRepository;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        ImmutableMap.Builder methodProcessorsBuilder = ImmutableMap.builder();
        methodProcessorsBuilder.put((Object)astClassFactory.getType(Provides.class), (Object)providesProcessor);
        this.methodProcessors = methodProcessorsBuilder.build();
        ImmutableMap.Builder typeProcessorsBuilder = ImmutableMap.builder();
        typeProcessorsBuilder.put((Object)astClassFactory.getType(BindInterceptor.class), (Object)bindInterceptorProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(BindInterceptors.class), (Object)configurationFactory.buildConfigurationComposite((TypeProcessor)bindInterceptorProcessor));
        typeProcessorsBuilder.put((Object)astClassFactory.getType(BindProvider.class), (Object)bindProviderProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(BindProviders.class), (Object)configurationFactory.buildConfigurationComposite((TypeProcessor)bindProviderProcessor));
        typeProcessorsBuilder.put((Object)astClassFactory.getType(Bind.class), (Object)bindProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(Bindings.class), (Object)configurationFactory.buildConfigurationComposite((TypeProcessor)bindProcessor));
        typeProcessorsBuilder.put((Object)astClassFactory.getType(UsesPermission.class), (Object)usesPermissionProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(UsesSdk.class), (Object)usesSdkProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(DefineScope.class), (Object)defineScopeProcessor);
        typeProcessorsBuilder.put((Object)astClassFactory.getType(DefineScopes.class), (Object)configurationFactory.buildConfigurationComposite((TypeProcessor)defineScopeProcessor));
        this.typeProcessors = typeProcessorsBuilder.build();
    }

    public Void innerRun(Provider<ASTType> astTypeProvider) {
        ASTType type = (ASTType)astTypeProvider.get();
        ImmutableList.Builder configurations = ImmutableList.builder();
        for (ASTAnnotation typeAnnotation : type.getAnnotations()) {
            if (!this.typeProcessors.containsKey((Object)typeAnnotation.getASTType())) continue;
            TypeProcessor typeProcessor = (TypeProcessor)this.typeProcessors.get((Object)typeAnnotation.getASTType());
            configurations.add((Object)typeProcessor.process(type, typeAnnotation));
        }
        for (ASTMethod astMethod : type.getMethods()) {
            for (ASTAnnotation astAnnotation : astMethod.getAnnotations()) {
                if (!this.methodProcessors.containsKey((Object)astAnnotation.getASTType())) continue;
                MethodProcessor methodProcessor = (MethodProcessor)this.methodProcessors.get((Object)astAnnotation.getASTType());
                configurations.add((Object)methodProcessor.process(type, astMethod, astAnnotation));
            }
        }
        InjectionNodeBuilderRepository repository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        for (ModuleConfiguration moduleConfiguration : configurations.build()) {
            moduleConfiguration.setConfiguration(repository);
        }
        this.moduleRepository.addModuleRepository(repository);
        return null;
    }
}

