/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.module;

import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.module.ModuleConfiguration;
import org.androidtransfuse.analysis.module.TypeProcessor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.processor.ManifestManager;

public class UsesPermissionProcessor
implements TypeProcessor {
    private final ManifestManager manifestManager;

    @Inject
    public UsesPermissionProcessor(ManifestManager manifestManager) {
        this.manifestManager = manifestManager;
    }

    public ModuleConfiguration process(ASTType moduleType, ASTAnnotation bindAnnotation) {
        String[] usesPermissions = (String[])bindAnnotation.getProperty("value", String[].class);
        return new UsesPermissionModuleConfiguration(usesPermissions);
    }

    private final class UsesPermissionModuleConfiguration
    implements ModuleConfiguration {
        private final String[] usesPermissions;

        private UsesPermissionModuleConfiguration(String[] usesPermissions) {
            this.usesPermissions = usesPermissions;
        }

        public void setConfiguration(InjectionNodeBuilderRepository configurationRepository) {
            for (String permission : this.usesPermissions) {
                UsesPermissionProcessor.this.manifestManager.addUsesPermission(permission);
            }
        }
    }
}

