/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.module;

import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.module.ModuleConfiguration;
import org.androidtransfuse.analysis.module.TypeProcessor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.model.manifest.UsesSDK;
import org.androidtransfuse.processor.ManifestManager;

public class UsesSdkProcessor
implements TypeProcessor {
    private final ManifestManager manifestManager;

    @Inject
    public UsesSdkProcessor(ManifestManager manifestManager) {
        this.manifestManager = manifestManager;
    }

    public ModuleConfiguration process(ASTType moduleType, ASTAnnotation bindAnnotation) {
        Integer min = (Integer)bindAnnotation.getProperty("min", Integer.class);
        Integer target = (Integer)bindAnnotation.getProperty("target", Integer.class);
        Integer max = (Integer)bindAnnotation.getProperty("max", Integer.class);
        return new UsesSdkModuleConfiguration(min, target, max);
    }

    private final class UsesSdkModuleConfiguration
    implements ModuleConfiguration {
        private final Integer min;
        private final Integer target;
        private final Integer max;

        private UsesSdkModuleConfiguration(Integer min, Integer target, Integer max) {
            this.min = min;
            this.target = target;
            this.max = max;
        }

        public void setConfiguration(InjectionNodeBuilderRepository configurationRepository) {
            UsesSDK usesSDK = new UsesSDK();
            boolean valueExists = false;
            if (this.min != null && this.min >= 0) {
                usesSDK.setMinSdkVersion(this.min);
                valueExists = true;
            }
            if (this.target != null && this.target >= 0) {
                usesSDK.setTargetSdkVersion(this.target);
                valueExists = true;
            }
            if (this.max != null && this.max >= 0) {
                usesSDK.setMaxSdkVersion(this.max);
                valueExists = true;
            }
            if (valueExists) {
                UsesSdkProcessor.this.manifestManager.setUsesSdk(usesSDK);
            }
        }
    }
}

