/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.repository;

import android.app.Activity;
import android.app.ActivityGroup;
import android.app.ListActivity;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.view.View;
import android.widget.ListView;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.repository.ActivityComponentBuilderRepository;
import org.androidtransfuse.annotations.OnBackPressed;
import org.androidtransfuse.annotations.OnDestroy;
import org.androidtransfuse.annotations.OnListItemClick;
import org.androidtransfuse.annotations.OnPause;
import org.androidtransfuse.annotations.OnRestart;
import org.androidtransfuse.annotations.OnRestoreInstanceState;
import org.androidtransfuse.annotations.OnResume;
import org.androidtransfuse.annotations.OnSaveInstanceState;
import org.androidtransfuse.annotations.OnStart;
import org.androidtransfuse.annotations.OnStop;
import org.androidtransfuse.gen.GeneratorFactory;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.componentBuilder.ListenerRegistrationGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodCallbackGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodGenerator;
import org.androidtransfuse.gen.componentBuilder.NonConfigurationInstanceGenerator;
import org.androidtransfuse.intentFactory.ActivityIntentFactoryStrategy;

public class ActivityComponentBuilderRepositoryFactory {
    private final ComponentBuilderFactory componentBuilderFactory;
    private final ASTClassFactory astClassFactory;
    private final GeneratorFactory generatorFactory;
    private final ListenerRegistrationGenerator listenerRegistrationGenerator;
    private final NonConfigurationInstanceGenerator nonConfigurationInstanceGenerator;

    @Inject
    public ActivityComponentBuilderRepositoryFactory(ASTClassFactory astClassFactory, ComponentBuilderFactory componentBuilderFactory, GeneratorFactory generatorFactory, ListenerRegistrationGenerator listenerRegistrationGenerator, NonConfigurationInstanceGenerator nonConfigurationInstanceGenerator) {
        this.astClassFactory = astClassFactory;
        this.componentBuilderFactory = componentBuilderFactory;
        this.generatorFactory = generatorFactory;
        this.listenerRegistrationGenerator = listenerRegistrationGenerator;
        this.nonConfigurationInstanceGenerator = nonConfigurationInstanceGenerator;
    }

    public ActivityComponentBuilderRepository build() {
        ImmutableMap.Builder methodCallbackGenerators = ImmutableMap.builder();
        ImmutableSet<ExpressionVariableDependentGenerator> activityMethodGenerators = this.buildActivityMethodCallbackGenerators();
        methodCallbackGenerators.put((Object)Activity.class.getName(), activityMethodGenerators);
        methodCallbackGenerators.put((Object)ListActivity.class.getName(), this.buildListActivityMethodCallbackGenerators((Set<ExpressionVariableDependentGenerator>)activityMethodGenerators));
        methodCallbackGenerators.put((Object)PreferenceActivity.class.getName(), activityMethodGenerators);
        methodCallbackGenerators.put((Object)ActivityGroup.class.getName(), activityMethodGenerators);
        return new ActivityComponentBuilderRepository((ImmutableMap<String, ImmutableSet<ExpressionVariableDependentGenerator>>)methodCallbackGenerators.build());
    }

    private ImmutableSet<ExpressionVariableDependentGenerator> buildListActivityMethodCallbackGenerators(Set<ExpressionVariableDependentGenerator> activityMethodGenerators) {
        ImmutableSet.Builder listActivityCallbackGenerators = ImmutableSet.builder();
        listActivityCallbackGenerators.addAll(activityMethodGenerators);
        ASTMethod onListItemClickMethod = this.getASTMethod(ListActivity.class, "onListItemClick", ListView.class, View.class, Integer.TYPE, Long.TYPE);
        listActivityCallbackGenerators.add((Object)this.componentBuilderFactory.buildMethodCallbackGenerator(this.astClassFactory.getType(OnListItemClick.class), (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(onListItemClickMethod, false)));
        return listActivityCallbackGenerators.build();
    }

    private ImmutableSet<ExpressionVariableDependentGenerator> buildActivityMethodCallbackGenerators() {
        ImmutableSet.Builder activityCallbackGenerators = ImmutableSet.builder();
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnDestroy.class, "onDestroy"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnPause.class, "onPause"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnRestart.class, "onRestart"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnResume.class, "onResume"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnStart.class, "onStart"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnStop.class, "onStop"));
        activityCallbackGenerators.add((Object)this.buildEventMethod(OnBackPressed.class, "onBackPressed"));
        ASTMethod onSaveInstanceStateMethod = this.getASTMethod("onSaveInstanceState", Bundle.class);
        activityCallbackGenerators.add((Object)this.componentBuilderFactory.buildMethodCallbackGenerator(this.astClassFactory.getType(OnSaveInstanceState.class), (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(onSaveInstanceStateMethod, true)));
        ASTMethod onRestoreInstanceState = this.getASTMethod("onRestoreInstanceState", Bundle.class);
        activityCallbackGenerators.add((Object)this.componentBuilderFactory.buildMethodCallbackGenerator(this.astClassFactory.getType(OnRestoreInstanceState.class), (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(onRestoreInstanceState, true)));
        activityCallbackGenerators.add((Object)this.generatorFactory.buildStrategyGenerator(ActivityIntentFactoryStrategy.class));
        activityCallbackGenerators.add((Object)this.listenerRegistrationGenerator);
        activityCallbackGenerators.add((Object)this.nonConfigurationInstanceGenerator);
        return activityCallbackGenerators.build();
    }

    private MethodCallbackGenerator buildEventMethod(Class<? extends Annotation> eventAnnotationClass, String methodName) {
        ASTMethod method = this.getASTMethod(methodName, new Class[0]);
        ASTType eventAnnotation = this.astClassFactory.getType(eventAnnotationClass);
        return this.componentBuilderFactory.buildMethodCallbackGenerator(eventAnnotation, (MethodGenerator)this.componentBuilderFactory.buildMirroredMethodGenerator(method, true));
    }

    private ASTMethod getASTMethod(String methodName, Class ... args) {
        return this.getASTMethod(Activity.class, methodName, args);
    }

    private ASTMethod getASTMethod(Class type, String methodName, Class ... args) {
        try {
            return this.astClassFactory.getMethod(type.getDeclaredMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while trying to reference method " + methodName, (Throwable)e);
        }
    }
}

