/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.repository;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.view.MenuInflater;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.JExpr;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.androidtransfuse.adapter.ASTStringType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.module.ModuleRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.ScopeAspectFactoryRepositoryProvider;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;

@Singleton
public class InjectionNodeBuilderRepositoryFactory
implements ModuleRepository {
    public static final String POWER_SERVICE = "power";
    public static final String WINDOW_SERVICE = "window";
    public static final String LAYOUT_INFLATER_SERVICE = "layout_inflater";
    public static final String ACCOUNT_SERVICE = "account";
    public static final String ACTIVITY_SERVICE = "activity";
    public static final String ALARM_SERVICE = "alarm";
    public static final String NOTIFICATION_SERVICE = "notification";
    public static final String ACCESSIBILITY_SERVICE = "accessibility";
    public static final String KEYGUARD_SERVICE = "keyguard";
    public static final String LOCATION_SERVICE = "location";
    public static final String SEARCH_SERVICE = "search";
    public static final String SENSOR_SERVICE = "sensor";
    public static final String STORAGE_SERVICE = "storage";
    public static final String WALLPAPER_SERVICE = "wallpaper";
    public static final String VIBRATOR_SERVICE = "vibrator";
    public static final String CONNECTIVITY_SERVICE = "connectivity";
    public static final String WIFI_SERVICE = "wifi";
    public static final String WIFI_P2P_SERVICE = "wifip2p";
    public static final String NSD_SERVICE = "servicediscovery";
    public static final String AUDIO_SERVICE = "audio";
    public static final String MEDIA_ROUTER_SERVICE = "media_router";
    public static final String TELEPHONY_SERVICE = "phone";
    public static final String CLIPBOARD_SERVICE = "clipboard";
    public static final String INPUT_METHOD_SERVICE = "input_method";
    public static final String TEXT_SERVICES_MANAGER_SERVICE = "textservices";
    public static final String DROPBOX_SERVICE = "dropbox";
    public static final String DEVICE_POLICY_SERVICE = "device_policy";
    public static final String UI_MODE_SERVICE = "uimode";
    public static final String DOWNLOAD_SERVICE = "download";
    public static final String NFC_SERVICE = "nfc";
    public static final String USB_SERVICE = "usb";
    public static final String INPUT_SERVICE = "input";
    private final ImmutableMap<String, ASTType> systemServices;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final Set<ASTType> installedComponents = new HashSet<ASTType>();
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;
    private final InjectionNodeBuilderRepository moduleRepository;

    @Inject
    public InjectionNodeBuilderRepositoryFactory(InjectionBindingBuilder injectionBindingBuilder, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider, ScopeAspectFactoryRepositoryProvider scopeAspectFactoryRepositoryProvider) {
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
        ImmutableMap.Builder systemServiceBuilder = ImmutableMap.builder();
        systemServiceBuilder.put((Object)ACCESSIBILITY_SERVICE, (Object)new ASTStringType("android.view.accessibility.AccessibilityManager"));
        systemServiceBuilder.put((Object)ACCOUNT_SERVICE, (Object)new ASTStringType("android.accounts.AccountManager"));
        systemServiceBuilder.put((Object)ACTIVITY_SERVICE, (Object)new ASTStringType("android.app.ActivityManager"));
        systemServiceBuilder.put((Object)ALARM_SERVICE, (Object)new ASTStringType("android.app.AlarmManager"));
        systemServiceBuilder.put((Object)AUDIO_SERVICE, (Object)new ASTStringType("android.media.AudioManager"));
        systemServiceBuilder.put((Object)CLIPBOARD_SERVICE, (Object)new ASTStringType("android.text.ClipboardManager"));
        systemServiceBuilder.put((Object)CONNECTIVITY_SERVICE, (Object)new ASTStringType("android.net.ConnectivityManager"));
        systemServiceBuilder.put((Object)DEVICE_POLICY_SERVICE, (Object)new ASTStringType("android.app.admin.DevicePolicyManager"));
        systemServiceBuilder.put((Object)DOWNLOAD_SERVICE, (Object)new ASTStringType("android.app.DownloadManager"));
        systemServiceBuilder.put((Object)DROPBOX_SERVICE, (Object)new ASTStringType("android.os.DropBoxManager"));
        systemServiceBuilder.put((Object)INPUT_METHOD_SERVICE, (Object)new ASTStringType("android.view.inputmethod.InputMethodManager"));
        systemServiceBuilder.put((Object)INPUT_SERVICE, (Object)new ASTStringType("android.hardware.input.InputManager"));
        systemServiceBuilder.put((Object)KEYGUARD_SERVICE, (Object)new ASTStringType("android.app.KeyguardManager"));
        systemServiceBuilder.put((Object)LAYOUT_INFLATER_SERVICE, (Object)new ASTStringType("android.view.LayoutInflater"));
        systemServiceBuilder.put((Object)LOCATION_SERVICE, (Object)new ASTStringType("android.location.LocationManager"));
        systemServiceBuilder.put((Object)MEDIA_ROUTER_SERVICE, (Object)new ASTStringType("android.media.MediaRouter"));
        systemServiceBuilder.put((Object)NFC_SERVICE, (Object)new ASTStringType("android.nfc.NfcManager"));
        systemServiceBuilder.put((Object)NSD_SERVICE, (Object)new ASTStringType("android.net.nsd.NsdManager"));
        systemServiceBuilder.put((Object)NOTIFICATION_SERVICE, (Object)new ASTStringType("android.app.NotificationManager"));
        systemServiceBuilder.put((Object)POWER_SERVICE, (Object)new ASTStringType("android.os.PowerManager"));
        systemServiceBuilder.put((Object)SEARCH_SERVICE, (Object)new ASTStringType("android.app.SearchManager"));
        systemServiceBuilder.put((Object)SENSOR_SERVICE, (Object)new ASTStringType("android.hardware.SensorManager"));
        systemServiceBuilder.put((Object)STORAGE_SERVICE, (Object)new ASTStringType("android.os.storage.StorageManager"));
        systemServiceBuilder.put((Object)TELEPHONY_SERVICE, (Object)new ASTStringType("android.telephony.TelephonyManager"));
        systemServiceBuilder.put((Object)TEXT_SERVICES_MANAGER_SERVICE, (Object)new ASTStringType("android.view.textservice.TextServicesManager"));
        systemServiceBuilder.put((Object)UI_MODE_SERVICE, (Object)new ASTStringType("android.app.UiModeManager"));
        systemServiceBuilder.put((Object)USB_SERVICE, (Object)new ASTStringType("android.hardware.usb.UsbManager"));
        systemServiceBuilder.put((Object)VIBRATOR_SERVICE, (Object)new ASTStringType("android.os.Vibrator"));
        systemServiceBuilder.put((Object)WALLPAPER_SERVICE, (Object)new ASTStringType("android.service.wallpaper.WallpaperService"));
        systemServiceBuilder.put((Object)WIFI_P2P_SERVICE, (Object)new ASTStringType("android.net.wifi.p2p.WifiP2pManager"));
        systemServiceBuilder.put((Object)WIFI_SERVICE, (Object)new ASTStringType("android.net.wifi.WifiManager"));
        systemServiceBuilder.put((Object)WINDOW_SERVICE, (Object)new ASTStringType("android.view.WindowManager"));
        this.systemServices = systemServiceBuilder.build();
        this.moduleRepository = (InjectionNodeBuilderRepository)injectionNodeBuilderRepositoryProvider.get();
        this.moduleRepository.addRepository(scopeAspectFactoryRepositoryProvider.get());
    }

    public InjectionNodeBuilderRepository buildApplicationInjections() {
        InjectionNodeBuilderRepository repository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        repository.putType(Resources.class, this.injectionBindingBuilder.dependency(Application.class).invoke(Resources.class, "getResources").build());
        repository.putType(MenuInflater.class, this.injectionBindingBuilder.dependency(Activity.class).invoke(MenuInflater.class, "getMenuInflater").build());
        for (Map.Entry systemServiceEntry : this.systemServices.entrySet()) {
            repository.putType((ASTType)systemServiceEntry.getValue(), this.injectionBindingBuilder.dependency(Context.class).invoke(Object.class, "getSystemService").arg(JExpr.lit((String)((String)systemServiceEntry.getKey()))).build());
        }
        repository.putType(SharedPreferences.class, this.injectionBindingBuilder.staticInvoke(PreferenceManager.class, SharedPreferences.class, "getDefaultSharedPreferences").dependencyArg(Context.class).build());
        return repository;
    }

    public InjectionNodeBuilderRepository buildModuleConfiguration() {
        InjectionNodeBuilderRepository repository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        repository.addRepository(this.moduleRepository);
        return repository;
    }

    public Collection<ASTType> getInstalledAnnotatedWith(Class<? extends Annotation> annotation) {
        ImmutableSet.Builder installedBuilder = ImmutableSet.builder();
        for (ASTType installedComponent : this.installedComponents) {
            if (!installedComponent.isAnnotated(annotation)) continue;
            installedBuilder.add((Object)installedComponent);
        }
        return installedBuilder.build();
    }

    public void addInstalledComponents(ASTType[] astType) {
        this.installedComponents.addAll(Arrays.asList(astType));
    }

    public void addModuleRepository(InjectionNodeBuilderRepository repository) {
        this.moduleRepository.addRepository(repository);
    }
}

