/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.analysis.repository;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.annotations.ContextScope;
import org.androidtransfuse.annotations.TransfuseModule;
import org.androidtransfuse.gen.scopeBuilder.ContextScopeAspectFactory;
import org.androidtransfuse.gen.scopeBuilder.ScopeAspectFactory;
import org.androidtransfuse.gen.scopeBuilder.SingletonScopeAspectFactory;
import org.androidtransfuse.scope.ConcurrentDoubleLockingScope;

public class ScopeAspectFactoryRepositoryProvider
implements Provider<InjectionNodeBuilderRepository> {
    private final SingletonScopeAspectFactory singletonScopeAspectFactory;
    private final ContextScopeAspectFactory contextScopeAspectFactory;
    private final ASTClassFactory astClassFactory;

    @Inject
    public ScopeAspectFactoryRepositoryProvider(SingletonScopeAspectFactory singletonScopeAspectFactory, ContextScopeAspectFactory contextScopeAspectFactory, ASTClassFactory astClassFactory) {
        this.singletonScopeAspectFactory = singletonScopeAspectFactory;
        this.contextScopeAspectFactory = contextScopeAspectFactory;
        this.astClassFactory = astClassFactory;
    }

    public InjectionNodeBuilderRepository get() {
        InjectionNodeBuilderRepository scopedVariableBuilderRepository = new InjectionNodeBuilderRepository(this.astClassFactory);
        ASTType concurrentScopeType = this.astClassFactory.getType(ConcurrentDoubleLockingScope.class);
        scopedVariableBuilderRepository.putScopeAspectFactory(this.astClassFactory.getType(TransfuseModule.class), concurrentScopeType, (ScopeAspectFactory)this.singletonScopeAspectFactory);
        scopedVariableBuilderRepository.putScopeAspectFactory(this.astClassFactory.getType(Singleton.class), concurrentScopeType, (ScopeAspectFactory)this.singletonScopeAspectFactory);
        scopedVariableBuilderRepository.putScopeAspectFactory(this.astClassFactory.getType(ContextScope.class), concurrentScopeType, (ScopeAspectFactory)this.contextScopeAspectFactory);
        return scopedVariableBuilderRepository;
    }
}

