/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import javax.inject.Provider;
import org.androidtransfuse.annotations.ConfigChanges;
import org.androidtransfuse.annotations.Labeled;
import org.androidtransfuse.annotations.LaunchMode;
import org.androidtransfuse.annotations.ScreenOrientation;
import org.androidtransfuse.annotations.UIOptions;
import org.androidtransfuse.annotations.WindowSoftInputMode;
import org.androidtransfuse.model.manifest.InstallLocation;
import org.androidtransfuse.model.manifest.LabeledConverter;
import org.androidtransfuse.model.manifest.Manifest;
import org.androidtransfuse.model.manifest.ProtectionLevel;
import org.androidtransfuse.model.manifest.ReqKeyboardType;
import org.androidtransfuse.model.manifest.ReqNavigation;
import org.androidtransfuse.model.manifest.ReqTouchScreen;
import org.androidtransfuse.model.manifest.ScreenDensity;
import org.androidtransfuse.model.manifest.ScreenSize;
import org.androidtransfuse.processor.MergeableTagConverter;

public class XStreamProvider
implements Provider<XStream> {
    public XStream get() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new FourSpaceTabXppDriver());
        xStream.processAnnotations(Manifest.class);
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ConfigChanges.class, (Labeled[])ConfigChanges.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(InstallLocation.class, (Labeled[])InstallLocation.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(LaunchMode.class, (Labeled[])LaunchMode.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ProtectionLevel.class, (Labeled[])ProtectionLevel.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ReqKeyboardType.class, (Labeled[])ReqKeyboardType.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ReqNavigation.class, (Labeled[])ReqNavigation.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ReqTouchScreen.class, (Labeled[])ReqTouchScreen.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ScreenDensity.class, (Labeled[])ScreenDensity.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ScreenOrientation.class, (Labeled[])ScreenOrientation.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(ScreenSize.class, (Labeled[])ScreenSize.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(UIOptions.class, (Labeled[])UIOptions.values()));
        xStream.registerConverter((SingleValueConverter)new LabeledConverter(WindowSoftInputMode.class, (Labeled[])WindowSoftInputMode.values()));
        xStream.registerConverter((SingleValueConverter)new MergeableTagConverter());
        return xStream;
    }

    private static final class FourSpaceTabXppDriver
    extends XppDriver {
        private FourSpaceTabXppDriver() {
        }

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out, PrettyPrintWriter.XML_QUIRKS, "    ".toCharArray(), super.getNameCoder());
        }
    }
}

