/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import com.sun.codemodel.JDefinedClass;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.gen.AnalysisGeneration;
import org.androidtransfuse.gen.ComponentGenerator;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.transaction.TransactionWorker;

public class AnalysisGenerationFactory {
    @Inject
    private Provider<ComponentGenerator> componentGeneratorProvider;

    public Provider<TransactionWorker<Provider<ASTType>, JDefinedClass>> buildAnalysisGenerationProvider(Provider<? extends Analysis<ComponentDescriptor>> analysis) {
        return new AnalysisGenerationProvider(analysis, this.componentGeneratorProvider);
    }

    private static final class AnalysisGenerationProvider
    implements Provider<TransactionWorker<Provider<ASTType>, JDefinedClass>> {
        private Provider<? extends Analysis<ComponentDescriptor>> analysis;
        private Provider<ComponentGenerator> generator;

        private AnalysisGenerationProvider(Provider<? extends Analysis<ComponentDescriptor>> analysis, Provider<ComponentGenerator> generator) {
            this.analysis = analysis;
            this.generator = generator;
        }

        public TransactionWorker<Provider<ASTType>, JDefinedClass> get() {
            return new AnalysisGeneration(this.analysis, this.generator);
        }
    }
}

