/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.ScopesGenerator;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.ComponentBuilderFactory;
import org.androidtransfuse.gen.componentBuilder.ExistingMethod;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodCallbackGenerator;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.scope.Scopes;

public class ComponentGenerator {
    private final JCodeModel codeModel;
    private final InjectionFragmentGenerator injectionFragmentGenerator;
    private final ComponentBuilderFactory componentBuilderFactory;
    private final ClassGenerationUtil generationUtil;
    private final UniqueVariableNamer namer;

    @Inject
    public ComponentGenerator(JCodeModel codeModel, InjectionFragmentGenerator injectionFragmentGenerator, ComponentBuilderFactory componentBuilderFactory, ClassGenerationUtil generationUtil, UniqueVariableNamer namer) {
        this.codeModel = codeModel;
        this.injectionFragmentGenerator = injectionFragmentGenerator;
        this.componentBuilderFactory = componentBuilderFactory;
        this.generationUtil = generationUtil;
        this.namer = namer;
    }

    public JDefinedClass generate(ComponentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        try {
            JDefinedClass definedClass = this.generationUtil.defineClass(descriptor.getPackageClass());
            definedClass._extends(this.codeModel.ref(descriptor.getType()));
            MethodDescriptor initMethodDescriptor = descriptor.getInitMethodBuilder().buildMethod(definedClass);
            JBlock block = initMethodDescriptor.getMethod().body();
            JClass scopesRef = this.codeModel.ref(Scopes.class);
            JInvocation scopesBuildInvocation = this.codeModel.directClass(ScopesGenerator.TRANSFUSE_SCOPES_UTIL.getCanonicalName()).staticInvoke("getInstance");
            JVar scopesVar = block.decl((JType)scopesRef, this.namer.generateName(Scopes.class), (JExpression)scopesBuildInvocation);
            Map expressionMap = this.injectionFragmentGenerator.buildFragment(block, definedClass, descriptor.getInjectionNodeFactory().buildInjectionNode(initMethodDescriptor), (JExpression)scopesVar);
            for (ExpressionVariableDependentGenerator registrationGenerator : descriptor.getRegistrations()) {
                registrationGenerator.generate(definedClass, initMethodDescriptor, expressionMap, descriptor, (JExpression)scopesVar);
            }
            ExistingMethod onCreateMethodGenerator = new ExistingMethod(initMethodDescriptor);
            MethodCallbackGenerator onCreateCallbackGenerator = this.componentBuilderFactory.buildMethodCallbackGenerator(descriptor.getInitMethodEventAnnotation(), onCreateMethodGenerator);
            onCreateCallbackGenerator.generate(definedClass, initMethodDescriptor, expressionMap, descriptor, (JExpression)scopesVar);
            for (ExpressionVariableDependentGenerator generator : descriptor.getGenerators()) {
                generator.generate(definedClass, initMethodDescriptor, expressionMap, descriptor, (JExpression)scopesVar);
            }
            descriptor.getInitMethodBuilder().closeMethod(initMethodDescriptor);
            return definedClass;
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Class Already Exists ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("ClassNotFoundException while building Injection Fragment", (Throwable)e);
        }
    }
}

