/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.transaction.AbstractCompletionTransactionWorker;
import org.androidtransfuse.util.Repository;

public class ComponentsGenerator
extends AbstractCompletionTransactionWorker<Map<Provider<ASTType>, JDefinedClass>, Void> {
    private static final PackageClass REPOSITORY_NAME = new PackageClass("org.androidtransfuse", "Transfuse$Components");
    private static final String MAP_NAME = "components";
    private static final String GET_METHOD = "get";
    private final ClassGenerationUtil generationUtil;
    private final JCodeModel codeModel;

    @Inject
    public ComponentsGenerator(ClassGenerationUtil generationUtil, JCodeModel codeModel) {
        this.generationUtil = generationUtil;
        this.codeModel = codeModel;
    }

    public Void innerRun(Map<Provider<ASTType>, JDefinedClass> components) {
        try {
            JDefinedClass componentsRepositoryClass = this.generationUtil.defineClass(REPOSITORY_NAME);
            componentsRepositoryClass._implements(this.codeModel.ref(Repository.class).narrow(Class.class));
            JClass mapType = this.codeModel.ref(Map.class).narrow(new Class[]{Class.class, Class.class});
            JClass hashMapType = this.codeModel.ref(HashMap.class).narrow(new Class[]{Class.class, Class.class});
            JFieldVar registrationMap = componentsRepositoryClass.field(12, (JType)mapType, MAP_NAME, (JExpression)JExpr._new((JClass)hashMapType));
            JMethod getMapMethod = componentsRepositoryClass.method(1, (JType)mapType, GET_METHOD);
            getMapMethod.body()._return((JExpression)registrationMap);
            JBlock componentsRegistrationBlock = componentsRepositoryClass.constructor(1).body();
            for (Map.Entry<Provider<ASTType>, JDefinedClass> componentEntry : components.entrySet()) {
                JClass componentClass = this.codeModel.ref(((ASTType)componentEntry.getKey().get()).getName());
                JClass androidClass = (JClass)componentEntry.getValue();
                if (androidClass == null) continue;
                componentsRegistrationBlock.add((JStatement)registrationMap.invoke("put").arg(componentClass.dotclass()).arg(androidClass.dotclass()));
            }
            return null;
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Already generated Factories class", (Throwable)e);
        }
    }
}

