/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import android.os.Bundle;
import android.os.Parcelable;
import com.google.common.collect.ImmutableMap;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTPrimitiveType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.analysis.astAnalyzer.IntentFactoryExtraAspect;
import org.androidtransfuse.annotations.Parcel;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.ParcelsGenerator;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.intentFactory.AbstractIntentFactoryStrategy;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;

public class IntentFactoryStrategyGenerator
implements ExpressionVariableDependentGenerator {
    private static final String STRATEGY_EXT = "Strategy";
    private final Class<? extends AbstractIntentFactoryStrategy> factoryStrategyClass;
    private final JCodeModel codeModel;
    private final ASTClassFactory astClassFactory;
    private final ClassGenerationUtil generationUtil;
    private final ImmutableMap<ASTPrimitiveType, String> methodMapping;

    @Inject
    public IntentFactoryStrategyGenerator(Class factoryStrategyClass, JCodeModel codeModel, ASTClassFactory astClassFactory, ClassGenerationUtil generationUtil) {
        this.factoryStrategyClass = factoryStrategyClass;
        this.codeModel = codeModel;
        this.astClassFactory = astClassFactory;
        this.generationUtil = generationUtil;
        ImmutableMap.Builder methodMappingBuilder = ImmutableMap.builder();
        methodMappingBuilder.put((Object)ASTPrimitiveType.BOOLEAN, (Object)"putBoolean");
        methodMappingBuilder.put((Object)ASTPrimitiveType.BYTE, (Object)"putByte");
        methodMappingBuilder.put((Object)ASTPrimitiveType.CHAR, (Object)"putChar");
        methodMappingBuilder.put((Object)ASTPrimitiveType.DOUBLE, (Object)"putDouble");
        methodMappingBuilder.put((Object)ASTPrimitiveType.FLOAT, (Object)"putFloat");
        methodMappingBuilder.put((Object)ASTPrimitiveType.INT, (Object)"putInt");
        methodMappingBuilder.put((Object)ASTPrimitiveType.LONG, (Object)"putLong");
        methodMappingBuilder.put((Object)ASTPrimitiveType.SHORT, (Object)"putShort");
        this.methodMapping = methodMappingBuilder.build();
    }

    @Override
    public void generate(JDefinedClass definedClass, MethodDescriptor methodDescriptor, Map<InjectionNode, TypedExpression> expressionMap, ComponentDescriptor descriptor, JExpression scopesExpression) {
        try {
            JDefinedClass strategyClass = this.generationUtil.defineClass(descriptor.getPackageClass().append(STRATEGY_EXT));
            strategyClass._extends(this.factoryStrategyClass);
            JInvocation getExtrasMethod = JExpr.invoke((String)"getExtras");
            List<IntentFactoryExtraAspect> extras = this.getExtras(expressionMap);
            JMethod constructor = strategyClass.constructor(1);
            JBlock constructorBody = constructor.body();
            JDocComment javadocComments = constructor.javadoc();
            javadocComments.append((Object)("Strategy Class for generating Intent for " + descriptor.getPackageClass().getClassName()));
            constructorBody.add((JStatement)JExpr.invoke((String)"super").arg(this.codeModel.ref(descriptor.getPackageClass().getFullyQualifiedName()).dotclass()).arg((JExpression)JExpr._new((JType)this.codeModel._ref(Bundle.class))));
            for (IntentFactoryExtraAspect extra : extras) {
                if (extra.isRequired()) {
                    JVar extraParam = constructor.param((JType)this.codeModel.ref(extra.getType().getName()), extra.getName());
                    constructorBody.add(this.buildBundleMethod(getExtrasMethod, extra.getType(), extra.getName(), extraParam));
                    javadocComments.addParam(extraParam);
                    continue;
                }
                JMethod setterMethod = strategyClass.method(1, (JType)strategyClass, "set" + this.upperFirst(extra.getName()));
                JVar extraParam = setterMethod.param((JType)this.codeModel.ref(extra.getType().getName()), extra.getName());
                JBlock setterBody = setterMethod.body();
                setterBody.add(this.buildBundleMethod(getExtrasMethod, extra.getType(), extra.getName(), extraParam));
                setterMethod.javadoc().append((Object)"Optional Extra parameter");
                setterMethod.javadoc().addParam(extraParam);
                setterBody._return(JExpr._this());
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Class already defined while trying to define IntentFactoryStrategy", (Throwable)e);
        }
    }

    private String upperFirst(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private JStatement buildBundleMethod(JInvocation extras, ASTType type, String name, JVar extraParam) {
        ASTPrimitiveType primitiveType = ASTPrimitiveType.getAutoboxType((String)type.getName());
        if (type instanceof ASTPrimitiveType) {
            primitiveType = (ASTPrimitiveType)type;
        }
        if (primitiveType != null) {
            return extras.invoke((String)this.methodMapping.get((Object)primitiveType)).arg(name).arg((JExpression)extraParam);
        }
        if (type.getName().equals(String.class.getName())) {
            return extras.invoke("putString").arg(name).arg((JExpression)extraParam);
        }
        if (type.implementsFrom(this.astClassFactory.getType(Serializable.class))) {
            return extras.invoke("putSerializable").arg(name).arg((JExpression)extraParam);
        }
        if (type.inheritsFrom(this.astClassFactory.getType(Parcelable.class))) {
            return extras.invoke("putParcelable").arg(name).arg((JExpression)extraParam);
        }
        if (type.isAnnotated(Parcel.class)) {
            JInvocation wrappedParcel = this.codeModel.ref(ParcelsGenerator.PARCELS_NAME.toString()).staticInvoke("wrap").arg((JExpression)extraParam);
            return extras.invoke("putParcelable").arg(name).arg((JExpression)wrappedParcel);
        }
        throw new TransfuseAnalysisException("Unable to find appropriate type to build intent factory strategy: " + type.getName());
    }

    private List<IntentFactoryExtraAspect> getExtras(Map<InjectionNode, TypedExpression> expressionMap) {
        HashSet<IntentFactoryExtraAspect> uniqueExtras = new HashSet<IntentFactoryExtraAspect>();
        ArrayList<IntentFactoryExtraAspect> extras = new ArrayList<IntentFactoryExtraAspect>();
        for (InjectionNode injectionNode : expressionMap.keySet()) {
            IntentFactoryExtraAspect intentFactoryExtra = (IntentFactoryExtraAspect)injectionNode.getAspect(IntentFactoryExtraAspect.class);
            if (intentFactoryExtra == null || uniqueExtras.contains(intentFactoryExtra)) continue;
            uniqueExtras.add(intentFactoryExtra);
            extras.add(intentFactoryExtra);
        }
        Collections.sort(extras);
        return extras;
    }
}

