/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTArrayType;
import org.androidtransfuse.adapter.ASTPrimitiveType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.annotations.Parcel;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.ParcelsGenerator;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.model.GetterSetterMethodPair;
import org.androidtransfuse.model.ParcelableDescriptor;
import org.androidtransfuse.util.ParcelWrapper;

public class ParcelableGenerator {
    private static final String CREATOR_CLASS_NAME = "CREATOR";
    private static final String CREATE_FROM_PARCEL = "createFromParcel";
    private static final String NEW_ARRAY = "newArray";
    private static final String WRITE_TO_PARCEL = "writeToParcel";
    private static final String DESCRIBE_CONTENTS = "describeContents";
    private static final String PARCELABLE_EXT = "$Parcelable";
    public static final String WRAP_METHOD = "wrap";
    private final JCodeModel codeModel;
    private final UniqueVariableNamer namer;
    private final ASTClassFactory astClassFactory;
    private final ClassGenerationUtil generationUtil;
    private final Map<ASTType, ReadWritePair> arrayParceableModfier = new HashMap<ASTType, ReadWritePair>();
    private final Map<ASTType, ReadWritePair> parceableModifier = new HashMap<ASTType, ReadWritePair>();
    private final Map<ASTType, ReadWritePair> classLoaderModifier = new HashMap<ASTType, ReadWritePair>();

    @Inject
    public ParcelableGenerator(JCodeModel codeModel, UniqueVariableNamer namer, ASTClassFactory astClassFactory, ClassGenerationUtil generationUtil) {
        this.codeModel = codeModel;
        this.namer = namer;
        this.astClassFactory = astClassFactory;
        this.generationUtil = generationUtil;
        this.setup();
    }

    public JDefinedClass generateParcelable(ASTType type, ParcelableDescriptor parcelableDescriptor) {
        try {
            JClass inputType = this.codeModel.ref(type.getName());
            JDefinedClass parcelableClass = this.generationUtil.defineClass(type.getPackageClass().append(PARCELABLE_EXT));
            parcelableClass._implements(Parcelable.class)._implements(this.codeModel.ref(ParcelWrapper.class).narrow((JType)inputType));
            JFieldVar wrapped = parcelableClass.field(4, (JType)inputType, this.namer.generateName(type));
            JMethod parcelConstructor = parcelableClass.constructor(1);
            JVar parcelParam = parcelConstructor.param((JType)this.codeModel.ref(android.os.Parcel.class), this.namer.generateName(android.os.Parcel.class));
            JBlock parcelConstructorBody = parcelConstructor.body();
            JMethod writeToParcelMethod = parcelableClass.method(1, (JType)this.codeModel.VOID, WRITE_TO_PARCEL);
            writeToParcelMethod.annotate(Override.class);
            JVar wtParcelParam = writeToParcelMethod.param(android.os.Parcel.class, this.namer.generateName(android.os.Parcel.class));
            JVar flags = writeToParcelMethod.param((JType)this.codeModel.INT, "flags");
            if (parcelableDescriptor.getParcelConverterType() == null) {
                parcelConstructorBody.assign((JAssignmentTarget)wrapped, (JExpression)JExpr._new((JType)inputType));
                for (GetterSetterMethodPair propertyMutator : parcelableDescriptor.getGetterSetterPairs()) {
                    this.buildReadFromParcel(parcelableClass, parcelConstructorBody, wrapped, propertyMutator, parcelParam);
                }
                for (GetterSetterMethodPair propertyMutator : parcelableDescriptor.getGetterSetterPairs()) {
                    this.buildWriteToParcel(writeToParcelMethod.body(), wtParcelParam, flags, propertyMutator, wrapped);
                }
            } else {
                JClass converterType = this.codeModel.ref(parcelableDescriptor.getParcelConverterType().getName());
                JFieldVar converterField = parcelableClass.field(4, (JType)converterType, this.namer.generateName(parcelableDescriptor.getParcelConverterType()), (JExpression)JExpr._new((JClass)converterType));
                parcelConstructorBody.assign((JAssignmentTarget)wrapped, (JExpression)JExpr.invoke((JExpression)converterField, (String)"fromParcel").arg((JExpression)parcelParam));
                writeToParcelMethod.body().invoke((JExpression)converterField, "toParcel").arg((JExpression)wrapped).arg((JExpression)wtParcelParam);
            }
            JMethod inputConstructor = parcelableClass.constructor(1);
            JVar inputParam = inputConstructor.param((JType)inputType, this.namer.generateName(type));
            inputConstructor.body().assign((JAssignmentTarget)wrapped, (JExpression)inputParam);
            JMethod describeContentsMethod = parcelableClass.method(1, (JType)this.codeModel.INT, DESCRIBE_CONTENTS);
            describeContentsMethod.annotate(Override.class);
            describeContentsMethod.body()._return(JExpr.lit((int)0));
            JMethod getWrappedMethod = parcelableClass.method(1, (JType)inputType, "getParcel");
            getWrappedMethod.annotate(Override.class);
            getWrappedMethod.body()._return((JExpression)wrapped);
            JDefinedClass creatorClass = parcelableClass._class(28, this.namer.generateClassName(Parcelable.Creator.class));
            creatorClass._implements(this.codeModel.ref(Parcelable.Creator.class).narrow((JClass)parcelableClass));
            JMethod createFromParcelMethod = creatorClass.method(1, (JType)parcelableClass, CREATE_FROM_PARCEL);
            createFromParcelMethod.annotate(Override.class);
            JVar cfpParcelParam = createFromParcelMethod.param(android.os.Parcel.class, this.namer.generateName(android.os.Parcel.class));
            createFromParcelMethod.body()._return((JExpression)JExpr._new((JClass)parcelableClass).arg((JExpression)cfpParcelParam));
            JMethod newArrayMethod = creatorClass.method(1, (JType)parcelableClass.array(), NEW_ARRAY);
            newArrayMethod.annotate(Override.class);
            JVar sizeParam = newArrayMethod.param((JType)this.codeModel.INT, "size");
            newArrayMethod.body()._return((JExpression)JExpr.newArray((JType)parcelableClass, (JExpression)sizeParam));
            JFieldVar creatorField = parcelableClass.field(25, (JType)creatorClass, CREATOR_CLASS_NAME, (JExpression)JExpr._new((JClass)creatorClass));
            creatorField.annotate(SuppressWarnings.class).param("value", "UnusedDeclaration");
            return parcelableClass;
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Class Already Exists: " + type.getName() + PARCELABLE_EXT, (Throwable)e);
        }
    }

    private void buildReadFromParcel(JDefinedClass parcelableClass, JBlock parcelConstructorBody, JFieldVar wrapped, GetterSetterMethodPair propertyGetter, JVar parcelParam) {
        ASTType returnType = propertyGetter.getGetter().getReturnType();
        JClass returnJClassRef = this.codeModel.ref(returnType.getName());
        if (this.parceableModifier.containsKey(returnType)) {
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)parcelParam.invoke(this.parceableModifier.get(returnType).getReadMethod()));
        } else if (this.arrayParceableModfier.containsKey(returnType)) {
            ReadWritePair readWritePair = this.arrayParceableModfier.get(returnType);
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)JExpr.invoke((JExpression)parcelParam, (String)readWritePair.getReadMethod()));
        } else if (this.classLoaderModifier.containsKey(returnType)) {
            ReadWritePair readWritePair = this.classLoaderModifier.get(returnType);
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)parcelParam.invoke(readWritePair.getReadMethod()).arg((JExpression)returnJClassRef.dotclass().invoke("getClassLoader")));
        } else if (returnType.implementsFrom(this.astClassFactory.getType(Parcelable.class))) {
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)JExpr.cast((JType)returnJClassRef, (JExpression)parcelParam.invoke("readParcelable").arg((JExpression)returnJClassRef.dotclass().invoke("getClassLoader"))));
        } else if (returnType.inheritsFrom(this.astClassFactory.getType(Serializable.class))) {
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)JExpr.cast((JType)returnJClassRef, (JExpression)parcelParam.invoke("readSerializable")));
        } else if (returnType.isAnnotated(Parcel.class)) {
            JClass wrapperRef = this.codeModel.ref(ParcelWrapper.class).narrow(this.codeModel.ref(returnType.getName()));
            parcelConstructorBody.invoke((JExpression)wrapped, propertyGetter.getSetter().getName()).arg((JExpression)JExpr.cast((JType)wrapperRef, (JExpression)parcelParam.invoke("readParcelable").arg((JExpression)parcelableClass.dotclass().invoke("getClassLoader"))).invoke("getParcel"));
        } else {
            throw new TransfuseAnalysisException("Unable to find appropriate Parcel method to read " + returnType.getName());
        }
    }

    private void buildWriteToParcel(JBlock body, JVar parcel, JVar flags, GetterSetterMethodPair propertyMutator, JFieldVar wrapped) {
        ASTType returnType = propertyMutator.getGetter().getReturnType();
        if (this.parceableModifier.containsKey(returnType)) {
            body.invoke((JExpression)parcel, this.parceableModifier.get(propertyMutator.getGetter().getReturnType()).getWriteMethod()).arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName()));
        } else if (this.arrayParceableModfier.containsKey(returnType)) {
            body.invoke((JExpression)parcel, this.arrayParceableModfier.get(propertyMutator.getGetter().getReturnType()).getWriteMethod()).arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName()));
        } else if (this.classLoaderModifier.containsKey(returnType)) {
            body.invoke((JExpression)parcel, this.classLoaderModifier.get(propertyMutator.getGetter().getReturnType()).getWriteMethod()).arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName()));
        } else if (returnType.implementsFrom(this.astClassFactory.getType(Parcelable.class))) {
            body.invoke((JExpression)parcel, "writeParcelable").arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName())).arg((JExpression)flags);
        } else if (returnType.inheritsFrom(this.astClassFactory.getType(Serializable.class))) {
            body.invoke((JExpression)parcel, "writeSerializable").arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName()));
        } else if (returnType.isAnnotated(Parcel.class)) {
            JInvocation wrappedParcel = this.codeModel.ref(ParcelsGenerator.PARCELS_NAME.toString()).staticInvoke(WRAP_METHOD).arg((JExpression)wrapped.invoke(propertyMutator.getGetter().getName()));
            body.invoke((JExpression)parcel, "writeParcelable").arg((JExpression)wrappedParcel).arg((JExpression)flags);
        } else {
            throw new TransfuseAnalysisException("Unable to find appropriate Parcel method to write " + returnType.getName());
        }
    }

    private void setup() {
        this.addPrimitivePair(ASTPrimitiveType.BYTE, "readByte", "writeByte");
        this.addPrimitivePair(ASTPrimitiveType.DOUBLE, "readDouble", "writeDouble");
        this.addPrimitivePair(ASTPrimitiveType.FLOAT, "readFloat", "writeFloat");
        this.addPrimitivePair(ASTPrimitiveType.INT, "readInt", "writeInt");
        this.addPrimitivePair(ASTPrimitiveType.LONG, "readLong", "writeLong");
        this.addPrimitiveArrayPair(ASTPrimitiveType.BYTE, "createByteArray", "writeByteArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.CHAR, "createCharArray", "writeCharArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.BOOLEAN, "createBooleanArray", "writeBooleanArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.INT, "createByteArray", "writeIntArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.LONG, "createLongArray", "writeLongArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.FLOAT, "createFloatArray", "writeFloatArray");
        this.addPrimitiveArrayPair(ASTPrimitiveType.DOUBLE, "createDoubleArray", "writeDoubleArray");
        this.addArrayPair(String[].class, "createStringArray", "writeStringArray");
        this.addPair(String.class, "readString", "writeString");
        this.addPair(IBinder.class, "readStrongBinder", "writeStrongBinder");
        this.addPair(Bundle.class, "readBundle", "writeBundle");
        this.addArrayPair(Object[].class, "readArray", "writeArray");
        this.addClassloaderPair(SparseArray.class, "readSparseArray", "writeSparseArray");
        this.addPair(SparseBooleanArray.class, "readSparseBooleanArray", "writeSparseBooleanArray");
        this.addPair(Exception.class, "readException", "writeException");
    }

    private void addClassloaderPair(Class clazz, String readSparseArray, String writeSparseArray) {
        ASTType astType = this.astClassFactory.getType(clazz);
        this.classLoaderModifier.put(astType, new ReadWritePair(readSparseArray, writeSparseArray));
    }

    private void addPair(Class clazz, String readMethod, String writeMethod) {
        this.addPair(this.astClassFactory.getType(clazz), readMethod, writeMethod);
    }

    private void addPrimitiveArrayPair(ASTPrimitiveType primitiveType, String readMethod, String writeMethod) {
        this.addArrayPair((ASTType)new ASTArrayType((ASTType)primitiveType), readMethod, writeMethod);
        this.addArrayPair((ASTType)new ASTArrayType(this.astClassFactory.getType(primitiveType.getObjectClass())), readMethod, writeMethod);
    }

    private void addArrayPair(Class clazz, String readMethod, String writeMethod) {
        this.addArrayPair(this.astClassFactory.getType(clazz), readMethod, writeMethod);
    }

    private void addArrayPair(ASTType astArrayType, String readMethod, String writeMethod) {
        this.arrayParceableModfier.put(astArrayType, new ReadWritePair(readMethod, writeMethod));
    }

    private void addPrimitivePair(ASTPrimitiveType primitiveType, String readMethod, String writeMethod) {
        this.addPair((ASTType)primitiveType, readMethod, writeMethod);
        this.addPair(this.astClassFactory.getType(primitiveType.getObjectClass()), readMethod, writeMethod);
    }

    private void addPair(ASTType astType, String readMethod, String writeMethod) {
        this.parceableModifier.put(astType, new ReadWritePair(readMethod, writeMethod));
    }

    public static final class ReadWritePair {
        private String readMethod;
        private String writeMethod;

        public ReadWritePair(String readMethod, String writeMethod) {
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        public String getReadMethod() {
            return this.readMethod;
        }

        public String getWriteMethod() {
            return this.writeMethod;
        }
    }
}

