/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.Parcels;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.util.Repository;
import org.androidtransfuse.util.TransfuseRuntimeException;

public class ParcelsGenerator {
    public static final PackageClass PARCELS_NAME = new PackageClass("org.androidtransfuse", "Parcels");
    public static final PackageClass REPOSITORY_NAME = new PackageClass("org.androidtransfuse", "Transfuse$Parcels");
    private static final String MAP_NAME = "parcelWrappers";
    private final ClassGenerationUtil classGenerationUtil;
    private final JCodeModel codeModel;
    private final UniqueVariableNamer uniqueVariableNamer;

    @Inject
    public ParcelsGenerator(ClassGenerationUtil classGenerationUtil, JCodeModel codeModel, UniqueVariableNamer uniqueVariableNamer) {
        this.classGenerationUtil = classGenerationUtil;
        this.codeModel = codeModel;
        this.uniqueVariableNamer = uniqueVariableNamer;
    }

    public void generate(Map<Provider<ASTType>, JDefinedClass> generated) {
        try {
            JDefinedClass parcelsDefinedClass = this.classGenerationUtil.defineClass(REPOSITORY_NAME);
            parcelsDefinedClass._implements(Repository.class);
            JClass mapRef = this.codeModel.ref(Map.class).narrow(new Class[]{Class.class, Parcels.ParcelableFactory.class});
            JClass hashMapRef = this.codeModel.ref(HashMap.class).narrow(new Class[]{Class.class, Parcels.ParcelableFactory.class});
            JFieldVar parcelWrappers = parcelsDefinedClass.field(12, (JType)mapRef, MAP_NAME, (JExpression)JExpr._new((JClass)hashMapRef));
            JBlock constructorBody = parcelsDefinedClass.constructor(1).body();
            for (Map.Entry<Provider<ASTType>, JDefinedClass> astTypeJDefinedClassEntry : generated.entrySet()) {
                JClass type = this.codeModel.ref(((ASTType)astTypeJDefinedClassEntry.getKey().get()).getName());
                String innerClassName = this.uniqueVariableNamer.generateClassName((JType)astTypeJDefinedClassEntry.getValue()) + "Factory";
                JDefinedClass factoryDefinedClass = parcelsDefinedClass._class(28, innerClassName);
                factoryDefinedClass._implements(this.codeModel.ref(Parcels.ParcelableFactory.class).narrow(type));
                JMethod method = factoryDefinedClass.method(1, (JType)astTypeJDefinedClassEntry.getValue(), "buildParcelable");
                method.annotate(Override.class);
                JVar input = method.param((JType)type, "input");
                method.body()._return((JExpression)JExpr._new((JClass)((JClass)astTypeJDefinedClassEntry.getValue())).arg((JExpression)input));
                constructorBody.invoke((JExpression)parcelWrappers, "put").arg((JExpression)type.staticRef("class")).arg((JExpression)JExpr._new((JClass)factoryDefinedClass));
            }
            JMethod getMethod = parcelsDefinedClass.method(1, (JType)mapRef, "get");
            getMethod.body()._return((JExpression)parcelWrappers);
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseRuntimeException("Class already exists", (Exception)((Object)e));
        }
    }
}

