/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.ActivityDelegateASTReference;
import org.androidtransfuse.gen.componentBuilder.RegistrationGenerator;
import org.androidtransfuse.model.TypedExpression;

public class ActivityDelegateRegistrationGenerator
implements RegistrationGenerator {
    private final ImmutableList<ASTMethod> methods;
    private final JCodeModel codeModel;
    private final UniqueVariableNamer namer;
    private final ActivityDelegateASTReference activityDelegateASTReference;

    @Inject
    public ActivityDelegateRegistrationGenerator(ActivityDelegateASTReference activityDelegateASTReference, ImmutableList<ASTMethod> methods, JCodeModel codeModel, UniqueVariableNamer namer) {
        this.methods = methods;
        this.codeModel = codeModel;
        this.namer = namer;
        this.activityDelegateASTReference = activityDelegateASTReference;
    }

    @Override
    public void build(JDefinedClass definedClass, JBlock block, TypedExpression value) {
        for (ASTMethod method : this.methods) {
            JMethod implementedMethod = definedClass.method(1, (JType)this.codeModel.ref(method.getReturnType().getName()), method.getName());
            implementedMethod.annotate(Override.class);
            HashMap<ASTParameter, JVar> parameterMap = new HashMap<ASTParameter, JVar>();
            for (ASTParameter astParameter : method.getParameters()) {
                JVar param = implementedMethod.param((JType)this.codeModel.ref(astParameter.getASTType().getName()), this.namer.generateName(astParameter.getASTType()));
                parameterMap.put(astParameter, param);
            }
            JExpression targetExpression = this.activityDelegateASTReference.buildReference(value);
            JInvocation delegateInvocation = targetExpression.invoke(method.getName());
            for (ASTParameter astParameter : method.getParameters()) {
                delegateInvocation.arg((JExpression)parameterMap.get(astParameter));
            }
            if (ASTVoidType.VOID.equals((Object)method.getReturnType())) {
                implementedMethod.body().add((JStatement)delegateInvocation);
                continue;
            }
            implementedMethod.body()._return((JExpression)delegateInvocation);
        }
    }
}

