/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import android.content.BroadcastReceiver;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.variableBuilder.InjectionBindingBuilder;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;

public class BroadcastReceiverInjectionNodeFactory
implements InjectionNodeFactory {
    private final AnalysisContextFactory analysisContextFactory;
    private final InjectionPointFactory injectionPointFactory;
    private final InjectionNodeBuilderRepository injectionNodeBuilderRepository;
    private final ASTType astType;
    private final InjectionBindingBuilder injectionBindingBuilder;
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory;

    @Inject
    public BroadcastReceiverInjectionNodeFactory(ASTType astType, AnalysisContextFactory analysisContextFactory, InjectionPointFactory injectionPointFactory, InjectionNodeBuilderRepository injectionNodeBuilderRepository, InjectionBindingBuilder injectionBindingBuilder, InjectionNodeBuilderRepositoryFactory injectionNodeBuilderRepositoryFactory) {
        this.analysisContextFactory = analysisContextFactory;
        this.injectionPointFactory = injectionPointFactory;
        this.injectionNodeBuilderRepository = injectionNodeBuilderRepository;
        this.astType = astType;
        this.injectionBindingBuilder = injectionBindingBuilder;
        this.injectionNodeBuilderRepositoryFactory = injectionNodeBuilderRepositoryFactory;
    }

    public InjectionNode buildInjectionNode(MethodDescriptor onCreateMethodDescriptor) {
        AnalysisContext context = this.analysisContextFactory.buildAnalysisContext(this.buildVariableBuilderMap(onCreateMethodDescriptor));
        return this.injectionPointFactory.buildInjectionNode(this.astType, context);
    }

    private InjectionNodeBuilderRepository buildVariableBuilderMap(MethodDescriptor methodDescriptor) {
        this.injectionNodeBuilderRepository.putType(BroadcastReceiver.class, this.injectionBindingBuilder.buildThis(BroadcastReceiver.class));
        for (Map.Entry parameterEntry : methodDescriptor.getParameters().entrySet()) {
            this.injectionNodeBuilderRepository.putType(((ASTParameter)parameterEntry.getKey()).getASTType(), this.injectionBindingBuilder.buildExpression((TypedExpression)parameterEntry.getValue()));
        }
        this.injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildApplicationInjections());
        this.injectionNodeBuilderRepository.addRepository(this.injectionNodeBuilderRepositoryFactory.buildModuleConfiguration());
        return this.injectionNodeBuilderRepository;
    }
}

