/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.ScopesGenerator;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.LayoutBuilder;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.scope.Scopes;
import org.androidtransfuse.util.Logger;

public class LayoutHandlerBuilder
implements LayoutBuilder {
    private final InjectionFragmentGenerator injectionFragmentGenerator;
    private final InjectionNode layoutHandlerInjectionNode;
    private final Logger logger;
    private final JCodeModel codeModel;
    private final UniqueVariableNamer namer;

    @Inject
    public LayoutHandlerBuilder(InjectionFragmentGenerator injectionFragmentGenerator, InjectionNode layoutHandlerInjectionNode, Logger logger, JCodeModel codeModel, UniqueVariableNamer namer) {
        this.injectionFragmentGenerator = injectionFragmentGenerator;
        this.layoutHandlerInjectionNode = layoutHandlerInjectionNode;
        this.logger = logger;
        this.codeModel = codeModel;
        this.namer = namer;
    }

    @Override
    public void buildLayoutCall(JDefinedClass definedClass, JBlock block) {
        try {
            JClass scopesRef = this.codeModel.ref(Scopes.class);
            JInvocation scopesBuildInvocation = this.codeModel.directClass(ScopesGenerator.TRANSFUSE_SCOPES_UTIL.getCanonicalName()).staticInvoke("getInstance");
            JVar scopesVar = block.decl((JType)scopesRef, this.namer.generateName(Scopes.class), (JExpression)scopesBuildInvocation);
            Map expressionMap = this.injectionFragmentGenerator.buildFragment(block, definedClass, this.layoutHandlerInjectionNode, (JExpression)scopesVar);
            JExpression layoutHandlerDelegate = ((TypedExpression)expressionMap.get(this.layoutHandlerInjectionNode)).getExpression();
            block.add((JStatement)layoutHandlerDelegate.invoke("invokeLayout"));
        }
        catch (ClassNotFoundException e) {
            this.logger.error("ClassNotFoundException while trying to generate LayoutHandler", (Throwable)e);
        }
        catch (JClassAlreadyExistsException e) {
            this.logger.error("JClassAlreadyExistsException while trying to generate LayoutHandler", (Throwable)e);
        }
    }
}

