/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.astAnalyzer.ListenerAspect;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.componentBuilder.MethodGenerator;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;

public class MethodCallbackGenerator
implements ExpressionVariableDependentGenerator {
    private final ASTType eventAnnotation;
    private final MethodGenerator methodGenerator;
    private final InvocationBuilder invocationBuilder;

    @Inject
    public MethodCallbackGenerator(ASTType eventAnnotation, MethodGenerator methodGenerator, InvocationBuilder invocationBuilder) {
        this.eventAnnotation = eventAnnotation;
        this.methodGenerator = methodGenerator;
        this.invocationBuilder = invocationBuilder;
    }

    @Override
    public void generate(JDefinedClass definedClass, MethodDescriptor creationMethodDescriptor, Map<InjectionNode, TypedExpression> expressionMap, ComponentDescriptor descriptor, JExpression scopesExpression) {
        MethodDescriptor methodDescriptor = null;
        for (Map.Entry<InjectionNode, TypedExpression> injectionNodeJExpressionEntry : expressionMap.entrySet()) {
            ListenerAspect methodCallbackAspect = (ListenerAspect)injectionNodeJExpressionEntry.getKey().getAspect(ListenerAspect.class);
            if (methodCallbackAspect == null || !methodCallbackAspect.contains(this.eventAnnotation)) continue;
            Set<ASTMethod> methods = methodCallbackAspect.getListeners(this.eventAnnotation);
            if (methodDescriptor == null) {
                methodDescriptor = this.methodGenerator.buildMethod(definedClass);
            }
            JBlock body = methodDescriptor.getMethod().body();
            for (ASTMethod methodCallback : methods) {
                List<ASTParameter> matchedParameters = this.matchMethodArguments(methodDescriptor.getASTMethod().getParameters(), methodCallback);
                ArrayList<ASTType> parameterTypes = new ArrayList<ASTType>();
                ArrayList<JExpression> parameters = new ArrayList<JExpression>();
                for (ASTParameter matchedParameter : matchedParameters) {
                    parameterTypes.add(matchedParameter.getASTType());
                    parameters.add(((TypedExpression)methodDescriptor.getParameters().get(matchedParameter)).getExpression());
                }
                JInvocation methodCall = this.invocationBuilder.buildMethodCall(methodCallback.getAccessModifier(), methodDescriptor.getASTMethod().getReturnType(), methodCallback.getName(), parameters, parameterTypes, injectionNodeJExpressionEntry.getValue().getType(), injectionNodeJExpressionEntry.getValue().getExpression());
                body.add((JStatement)methodCall);
            }
        }
        this.methodGenerator.closeMethod(methodDescriptor);
    }

    private List<ASTParameter> matchMethodArguments(List<ASTParameter> parametersToMatch, ASTMethod methodToCall) {
        ArrayList<ASTParameter> arguments = new ArrayList<ASTParameter>();
        ArrayList<ASTParameter> overrideParameters = new ArrayList<ASTParameter>(parametersToMatch);
        block0: for (ASTParameter callParameter : methodToCall.getParameters()) {
            Iterator overrideParameterIterator = overrideParameters.iterator();
            while (overrideParameterIterator.hasNext()) {
                ASTParameter overrideParameter = (ASTParameter)overrideParameterIterator.next();
                if (!overrideParameter.getASTType().equals(callParameter.getASTType())) continue;
                arguments.add(overrideParameter);
                overrideParameterIterator.remove();
                continue block0;
            }
        }
        return arguments;
    }
}

