/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.analysis.astAnalyzer.NonConfigurationAspect;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.FieldInjectionPoint;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;

public class NonConfigurationInstanceGenerator
implements ExpressionVariableDependentGenerator {
    private final UniqueVariableNamer namer;
    private final JCodeModel codeModel;
    private final InvocationBuilder invocationBuilder;
    private final TypedExpressionFactory typeExpressionFactory;

    @Inject
    public NonConfigurationInstanceGenerator(UniqueVariableNamer namer, JCodeModel codeModel, InvocationBuilder invocationBuilder, TypedExpressionFactory typeExpressionFactory) {
        this.namer = namer;
        this.codeModel = codeModel;
        this.invocationBuilder = invocationBuilder;
        this.typeExpressionFactory = typeExpressionFactory;
    }

    @Override
    public void generate(JDefinedClass definedClass, MethodDescriptor methodDescriptor, Map<InjectionNode, TypedExpression> expressionMap, ComponentDescriptor descriptor, JExpression scopesExpression) {
        try {
            List<InjectionNode> nonConfigurationComponents = this.buildNonConfigurationComponents(expressionMap);
            if (!nonConfigurationComponents.isEmpty()) {
                JDefinedClass nonConfigurationInstance = definedClass._class(28, this.namer.generateClassName("NonConfigurationInstance"));
                JMethod constructor = nonConfigurationInstance.constructor(4);
                Map<FieldInjectionPoint, JFieldVar> fieldMap = this.configureConstructor(constructor, nonConfigurationInstance, nonConfigurationComponents);
                JBlock body = methodDescriptor.getMethod().body();
                JVar bodyVar = body.decl((JType)nonConfigurationInstance, this.namer.generateName((JType)nonConfigurationInstance), (JExpression)JExpr.cast((JType)nonConfigurationInstance, (JExpression)JExpr.invoke((String)"getLastNonConfigurationInstance")));
                JBlock conditional = body._if(bodyVar.ne(JExpr._null()))._then();
                for (InjectionNode nonConfigurationComponent : nonConfigurationComponents) {
                    NonConfigurationAspect aspect = (NonConfigurationAspect)nonConfigurationComponent.getAspect(NonConfigurationAspect.class);
                    for (FieldInjectionPoint nonConfigurationField : aspect.getFields()) {
                        TypedExpression fieldExpression = this.typeExpressionFactory.build(nonConfigurationField.getInjectionNode().getASTType(), (JExpression)JExpr.ref((JExpression)bodyVar, (JVar)((JVar)fieldMap.get(nonConfigurationField))));
                        conditional.add(this.invocationBuilder.buildFieldSet(fieldExpression, nonConfigurationField, expressionMap.get(nonConfigurationComponent).getExpression()));
                    }
                }
                JMethod onNonConfigInst = definedClass.method(1, Object.class, "onRetainNonConfigurationInstance");
                onNonConfigInst.annotate(Override.class);
                JBlock methodBody = onNonConfigInst.body();
                JInvocation construction = JExpr._new((JClass)nonConfigurationInstance);
                JVar instanceDecl = methodBody.decl((JType)nonConfigurationInstance, this.namer.generateName((JType)nonConfigurationInstance), (JExpression)construction);
                for (InjectionNode injectionNode : nonConfigurationComponents) {
                    NonConfigurationAspect aspect = (NonConfigurationAspect)injectionNode.getAspect(NonConfigurationAspect.class);
                    for (FieldInjectionPoint fieldInjectionPoint : aspect.getFields()) {
                        construction.arg(this.invocationBuilder.buildFieldGet(fieldInjectionPoint.getInjectionNode().getASTType(), expressionMap.get(injectionNode).getType(), expressionMap.get(injectionNode).getExpression(), fieldInjectionPoint.getName(), fieldInjectionPoint.getAccessModifier()));
                    }
                }
                methodBody._return((JExpression)instanceDecl);
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Class already defined", (Throwable)e);
        }
    }

    private Map<FieldInjectionPoint, JFieldVar> configureConstructor(JMethod constructor, JDefinedClass nonConfigurationInstance, List<InjectionNode> nonConfigurationComponents) {
        HashMap<FieldInjectionPoint, JFieldVar> fieldMap = new HashMap<FieldInjectionPoint, JFieldVar>();
        for (InjectionNode injectionNode : nonConfigurationComponents) {
            NonConfigurationAspect aspect = (NonConfigurationAspect)injectionNode.getAspect(NonConfigurationAspect.class);
            for (FieldInjectionPoint fieldInjectionPoint : aspect.getFields()) {
                JClass fieldNodeType = this.codeModel.ref(fieldInjectionPoint.getInjectionNode().getASTType().getName());
                JVar param = constructor.param((JType)fieldNodeType, this.namer.generateName(fieldInjectionPoint.getInjectionNode()));
                JFieldVar field = nonConfigurationInstance.field(4, (JType)fieldNodeType, this.namer.generateName(injectionNode));
                constructor.body().assign((JAssignmentTarget)field, (JExpression)param);
                fieldMap.put(fieldInjectionPoint, field);
            }
        }
        return fieldMap;
    }

    private List<InjectionNode> buildNonConfigurationComponents(Map<InjectionNode, TypedExpression> expressionMap) {
        ArrayList<InjectionNode> nonConfigurationComponents = new ArrayList<InjectionNode>();
        for (Map.Entry<InjectionNode, TypedExpression> expressionEntry : expressionMap.entrySet()) {
            if (!expressionEntry.getKey().containsAspect(NonConfigurationAspect.class)) continue;
            nonConfigurationComponents.add(expressionEntry.getKey());
        }
        return nonConfigurationComponents;
    }
}

