/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.analysis.astAnalyzer.ObservesAspect;
import org.androidtransfuse.event.EventObserver;
import org.androidtransfuse.event.WeakObserver;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.TypedExpression;

public class ObservesRegistrationGenerator
implements ExpressionVariableDependentGenerator {
    private static final String SUPER_REF = "super";
    private final JCodeModel codeModel;
    private final UniqueVariableNamer namer;
    private final InjectionFragmentGenerator injectionFragmentGenerator;
    private final InvocationBuilder invocationBuilder;

    @Inject
    public ObservesRegistrationGenerator(JCodeModel codeModel, UniqueVariableNamer namer, InjectionFragmentGenerator injectionFragmentGenerator, InvocationBuilder invocationBuilder) {
        this.codeModel = codeModel;
        this.namer = namer;
        this.injectionFragmentGenerator = injectionFragmentGenerator;
        this.invocationBuilder = invocationBuilder;
    }

    @Override
    public void generate(JDefinedClass definedClass, MethodDescriptor methodDescriptor, Map<InjectionNode, TypedExpression> expressionMap, ComponentDescriptor descriptor, JExpression scopesExpression) {
        try {
            InjectionNode tendingInjectionNode = this.getTendingInjectionNode(expressionMap);
            JBlock block = methodDescriptor.getMethod().body();
            Map<JClass, JVar> observerTuples = this.getObservers(definedClass, block, expressionMap);
            if (!observerTuples.isEmpty() && tendingInjectionNode != null) {
                TypedExpression tendingExpression = this.buildEventTending(block, definedClass, tendingInjectionNode, scopesExpression, expressionMap);
                for (Map.Entry<JClass, JVar> tupleEntry : observerTuples.entrySet()) {
                    block.invoke(tendingExpression.getExpression(), "addObserver").arg(tupleEntry.getKey().dotclass()).arg((JExpression)tupleEntry.getValue());
                }
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Tried to generate a class that already exists", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("Tried to generate a class that already exists", (Throwable)e);
        }
    }

    private Map<JClass, JVar> getObservers(JDefinedClass definedClass, JBlock block, Map<InjectionNode, TypedExpression> expressionMap) throws JClassAlreadyExistsException {
        HashMap<JClass, JVar> observerTuples = new HashMap<JClass, JVar>();
        for (Map.Entry<InjectionNode, TypedExpression> expressionEntry : expressionMap.entrySet()) {
            if (!expressionEntry.getKey().containsAspect(ObservesAspect.class)) continue;
            ObservesAspect aspect = (ObservesAspect)expressionEntry.getKey().getAspect(ObservesAspect.class);
            TypedExpression typedExpression = expressionEntry.getValue();
            for (ASTType event : aspect.getEvents()) {
                JClass eventRef = this.codeModel.ref(event.getName());
                JClass targetRef = this.codeModel.ref(typedExpression.getType().getName());
                JDefinedClass observerClass = definedClass._class(26, this.namer.generateClassName(typedExpression.getType()));
                JMethod constructor = observerClass.constructor(1);
                JVar constTargetParam = constructor.param((JType)targetRef, this.namer.generateName((JType)targetRef));
                constructor.body().invoke(SUPER_REF).arg((JExpression)constTargetParam);
                observerClass._extends(this.codeModel.ref(WeakObserver.class).narrow(eventRef).narrow(targetRef));
                JMethod triggerMethod = observerClass.method(1, (JType)this.codeModel.VOID, "trigger");
                triggerMethod.annotate(Override.class);
                JVar eventParam = triggerMethod.param((JType)eventRef, this.namer.generateName(event));
                JVar targetParam = triggerMethod.param((JType)targetRef, this.namer.generateName(typedExpression.getType()));
                JBlock triggerBody = triggerMethod.body();
                HashSet<JVar> parameters = new HashSet<JVar>();
                parameters.add(eventParam);
                for (ASTMethod observerMethod : aspect.getObserverMethods(event)) {
                    triggerBody.add((JStatement)this.invocationBuilder.buildMethodCall(observerMethod.getAccessModifier(), (ASTType)ASTVoidType.VOID, observerMethod.getName(), parameters, Collections.singletonList(event), typedExpression.getType(), (JExpression)targetParam));
                }
                JVar observer = block.decl((JType)observerClass, this.namer.generateName(EventObserver.class), (JExpression)JExpr._new((JClass)observerClass).arg(typedExpression.getExpression()));
                observerTuples.put(eventRef, observer);
            }
        }
        return observerTuples;
    }

    private InjectionNode getTendingInjectionNode(Map<InjectionNode, TypedExpression> expressionMap) {
        for (Map.Entry<InjectionNode, TypedExpression> expressionEntry : expressionMap.entrySet()) {
            if (!expressionEntry.getKey().containsAspect(ObservesAspect.class)) continue;
            ObservesAspect aspect = (ObservesAspect)expressionEntry.getKey().getAspect(ObservesAspect.class);
            return aspect.getObserverTendingInjectionNode();
        }
        return null;
    }

    private TypedExpression buildEventTending(JBlock block, JDefinedClass definedClass, InjectionNode tendingInjectionNode, JExpression scopesExpression, Map<InjectionNode, TypedExpression> expressionMap) throws ClassNotFoundException, JClassAlreadyExistsException {
        this.injectionFragmentGenerator.buildFragment(block, definedClass, tendingInjectionNode, scopesExpression, expressionMap);
        return expressionMap.get(tendingInjectionNode);
    }
}

