/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.LayoutBuilder;
import org.androidtransfuse.gen.componentBuilder.MethodBuilder;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.MethodDescriptorBuilder;
import org.androidtransfuse.model.TypedExpression;

public class OnCreateMethodBuilder
implements MethodBuilder {
    private final JCodeModel codeModel;
    private final ASTMethod onCreateASTMethod;
    private final UniqueVariableNamer namer;
    private final LayoutBuilder layoutBuilder;

    @Inject
    public OnCreateMethodBuilder(ASTMethod onCreateASTMethod, LayoutBuilder layoutBuilder, JCodeModel codeModel, UniqueVariableNamer namer) {
        this.codeModel = codeModel;
        this.onCreateASTMethod = onCreateASTMethod;
        this.namer = namer;
        this.layoutBuilder = layoutBuilder;
    }

    @Override
    public MethodDescriptor buildMethod(JDefinedClass definedClass) {
        JMethod onCreateMethod = definedClass.method(1, (JType)this.codeModel.VOID, "onCreate");
        onCreateMethod.annotate(Override.class);
        MethodDescriptorBuilder onCreateMethodDescriptorBuilder = new MethodDescriptorBuilder(onCreateMethod, this.onCreateASTMethod);
        ArrayList<JVar> parameters = new ArrayList<JVar>();
        for (ASTParameter methodArgument : this.onCreateASTMethod.getParameters()) {
            JVar param = onCreateMethod.param((JType)this.codeModel.ref(methodArgument.getASTType().getName()), this.namer.generateName(methodArgument.getASTType()));
            parameters.add(param);
            onCreateMethodDescriptorBuilder.putParameter(methodArgument, new TypedExpression(methodArgument.getASTType(), (JExpression)param));
        }
        JBlock block = onCreateMethod.body();
        JInvocation invocation = block.invoke(JExpr._super(), onCreateMethod);
        for (JVar parameter : parameters) {
            invocation.arg((JExpression)parameter);
        }
        this.layoutBuilder.buildLayoutCall(definedClass, block);
        return onCreateMethodDescriptorBuilder.build();
    }

    @Override
    public void closeMethod(MethodDescriptor descriptor) {
    }
}

