/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.MethodBuilder;
import org.androidtransfuse.model.MethodDescriptor;
import org.androidtransfuse.model.MethodDescriptorBuilder;
import org.androidtransfuse.model.TypedExpression;

public class OnReceiveMethodBuilder
implements MethodBuilder {
    private final JCodeModel codeModel;
    private final ASTClassFactory astClassFactory;
    private final UniqueVariableNamer namer;

    @Inject
    public OnReceiveMethodBuilder(JCodeModel codeModel, ASTClassFactory astClassFactory, UniqueVariableNamer namer) {
        this.codeModel = codeModel;
        this.astClassFactory = astClassFactory;
        this.namer = namer;
    }

    @Override
    public MethodDescriptor buildMethod(JDefinedClass definedClass) {
        try {
            JMethod onReceiveMethod = definedClass.method(1, (JType)this.codeModel.VOID, "onReceive");
            onReceiveMethod.annotate(Override.class);
            ASTMethod onReceiveASTMethod = this.astClassFactory.getMethod(BroadcastReceiver.class.getDeclaredMethod("onReceive", Context.class, Intent.class));
            MethodDescriptorBuilder methodDescriptor = new MethodDescriptorBuilder(onReceiveMethod, onReceiveASTMethod);
            for (ASTParameter astParameter : onReceiveASTMethod.getParameters()) {
                JVar param = onReceiveMethod.param((JType)this.codeModel.ref(astParameter.getASTType().getName()), this.namer.generateName(astParameter.getASTType()));
                methodDescriptor.putParameter(astParameter, new TypedExpression(astParameter.getASTType(), (JExpression)param));
            }
            return methodDescriptor.build();
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAnalysisException("NoSuchMethodException while looking up onReceive method", (Throwable)e);
        }
    }

    @Override
    public void closeMethod(MethodDescriptor descriptor) {
    }
}

