/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.componentBuilder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.componentBuilder.RegistrationGenerator;
import org.androidtransfuse.gen.componentBuilder.ViewRegistrationInvocationBuilder;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.TypedExpression;

public class ViewRegistrationGenerator
implements RegistrationGenerator {
    private final InjectionNode viewInjectionNode;
    private final String method;
    private final InjectionNode injectionNode;
    private final ViewRegistrationInvocationBuilder viewRegistrationInvocationBuilder;
    private final InjectionFragmentGenerator injectionFragmentGenerator;

    @Inject
    public ViewRegistrationGenerator(@Named(value="viewInjectionNode") InjectionNode viewInjectionNode, String method, @Named(value="targetInjectionNode") InjectionNode injectionNode, ViewRegistrationInvocationBuilder viewRegistrationInvocationBuilder, InjectionFragmentGenerator injectionFragmentGenerator) {
        this.viewInjectionNode = viewInjectionNode;
        this.method = method;
        this.injectionNode = injectionNode;
        this.viewRegistrationInvocationBuilder = viewRegistrationInvocationBuilder;
        this.injectionFragmentGenerator = injectionFragmentGenerator;
    }

    @Override
    public void build(JDefinedClass definedClass, JBlock block, TypedExpression value) {
        try {
            Map viewExpressionMap = this.injectionFragmentGenerator.buildFragment(block, definedClass, this.viewInjectionNode, null);
            JExpression viewExpression = ((TypedExpression)viewExpressionMap.get(this.viewInjectionNode)).getExpression();
            this.viewRegistrationInvocationBuilder.buildInvocation(block, value, viewExpression, this.method, this.injectionNode);
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("Class not found", (Throwable)e);
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("Class already exists", (Throwable)e);
        }
    }
}

