/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.scopeBuilder;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import javax.inject.Inject;
import org.androidtransfuse.gen.InjectionBuilderContext;
import org.androidtransfuse.gen.InjectionExpressionBuilder;
import org.androidtransfuse.gen.ProviderGenerator;
import org.androidtransfuse.gen.invocationBuilder.TypeInvocationHelper;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.scope.ContextScopeHolder;
import org.androidtransfuse.scope.ScopeKey;

public class ContextScopeVariableBuilder
implements VariableBuilder {
    private final ProviderGenerator providerGenerator;
    private final JCodeModel codeModel;
    private final TypedExpressionFactory typedExpressionFactory;
    private final InjectionNode contextScopeHolder;
    private final InjectionExpressionBuilder injectionExpressionBuilder;
    private final TypeInvocationHelper invocationHelper;

    @Inject
    public ContextScopeVariableBuilder(InjectionNode contextScopeHolder, JCodeModel codeModel, ProviderGenerator providerGenerator, TypedExpressionFactory typedExpressionFactory, InjectionExpressionBuilder injectionExpressionBuilder, TypeInvocationHelper invocationHelper) {
        this.codeModel = codeModel;
        this.providerGenerator = providerGenerator;
        this.typedExpressionFactory = typedExpressionFactory;
        this.contextScopeHolder = contextScopeHolder;
        this.injectionExpressionBuilder = injectionExpressionBuilder;
        this.invocationHelper = invocationHelper;
    }

    public TypedExpression buildVariable(InjectionBuilderContext injectionBuilderContext, InjectionNode injectionNode) {
        JDefinedClass providerClass = this.providerGenerator.generateProvider(injectionNode, true);
        JInvocation provider = JExpr._new((JClass)providerClass).arg(injectionBuilderContext.getScopeVar());
        TypedExpression contextScopeHolderExpression = this.injectionExpressionBuilder.buildVariable(injectionBuilderContext, this.contextScopeHolder);
        JExpression cast = this.invocationHelper.coerceType(ContextScopeHolder.class, contextScopeHolderExpression);
        JInvocation scopeVar = cast.invoke("getScope");
        JInvocation expression = scopeVar.invoke("getScopedObject").arg((JExpression)this.buildScopeKey(injectionNode)).arg((JExpression)provider);
        return this.typedExpressionFactory.build(injectionNode.getASTType(), (JExpression)expression);
    }

    private JInvocation buildScopeKey(InjectionNode injectionNode) {
        InjectionSignature signature = injectionNode.getTypeSignature();
        JClass injectionNodeClassRef = this.codeModel.ref(injectionNode.getClassName());
        return JExpr._new((JClass)this.codeModel.ref(ScopeKey.class).narrow(injectionNodeClassRef)).arg(JExpr.lit((String)signature.buildScopeKeySignature()));
    }
}

