/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import javax.inject.Inject;
import javax.inject.Named;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.gen.variableBuilder.DependentVariableBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class DependentInjectionNodeBuilder
implements InjectionNodeBuilder {
    private final Class dependency;
    private final Class returnType;
    private final DependentVariableBuilder variableBuilder;
    private final InjectionPointFactory injectionPointFactory;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final Analyzer analyzer;

    @Inject
    public DependentInjectionNodeBuilder(@Named(value="dependency") Class dependency, @Named(value="returnType") Class returnType, DependentVariableBuilder variableBuilder, InjectionPointFactory injectionPointFactory, VariableInjectionBuilderFactory variableInjectionBuilderFactory, Analyzer analyzer) {
        this.dependency = dependency;
        this.returnType = returnType;
        this.variableBuilder = variableBuilder;
        this.injectionPointFactory = injectionPointFactory;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context) {
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        InjectionNode contextInjectionNode = this.injectionPointFactory.buildInjectionNode(this.dependency, context);
        injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildDependentVariableBuilderWrapper(contextInjectionNode, this.variableBuilder, this.returnType));
        return injectionNode;
    }
}

