/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import android.app.Activity;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.astAnalyzer.IntentFactoryExtraAspect;
import org.androidtransfuse.annotations.Extra;
import org.androidtransfuse.annotations.Parcel;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilderSingleAnnotationAdapter;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class ExtraInjectionNodeBuilder
extends InjectionNodeBuilderSingleAnnotationAdapter {
    private final InjectionPointFactory injectionPointFactory;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final Analyzer analyzer;

    @Inject
    public ExtraInjectionNodeBuilder(InjectionPointFactory injectionPointFactory, VariableInjectionBuilderFactory variableInjectionBuilderFactory, Analyzer analyzer) {
        super(Extra.class);
        this.injectionPointFactory = injectionPointFactory;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context, ASTAnnotation annotation) {
        String extraId = (String)annotation.getProperty("value", String.class);
        Boolean optional = (Boolean)annotation.getProperty("optional", Boolean.class);
        if (optional == null) {
            optional = false;
        }
        boolean wrapped = signature.getType().isAnnotated(Parcel.class);
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        InjectionNode activityInjectionNode = this.injectionPointFactory.buildInjectionNode(Activity.class, context);
        injectionNode.addAspect(IntentFactoryExtraAspect.class, (Object)new IntentFactoryExtraAspect(optional == false, extraId, signature.getType()));
        injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildExtraVariableBuilder(extraId, activityInjectionNode, optional, wrapped));
        return injectionNode;
    }
}

