/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import com.sun.codemodel.JCodeModel;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.annotations.View;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilderSingleAnnotationAdapter;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class FragmentViewInjectionNodeBuilder
extends InjectionNodeBuilderSingleAnnotationAdapter {
    private final JCodeModel codeModel;
    private final InjectionPointFactory injectionPointFactory;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final Analyzer analyzer;

    @Inject
    public FragmentViewInjectionNodeBuilder(JCodeModel codeModel, InjectionPointFactory injectionPointFactory, VariableInjectionBuilderFactory variableInjectionBuilderFactory, Analyzer analyzer) {
        super(View.class);
        this.codeModel = codeModel;
        this.injectionPointFactory = injectionPointFactory;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context, ASTAnnotation annotation) {
        Integer viewId = (Integer)annotation.getProperty("value", Integer.class);
        String viewTag = (String)annotation.getProperty("tag", String.class);
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        InjectionNode viewInjectionNode = this.injectionPointFactory.buildInjectionNode(android.view.View.class, context);
        try {
            injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildFragmentViewVariableBuilder(viewId, viewTag, viewInjectionNode, this.codeModel.parseType(signature.getType().getName())));
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("Unable to parse type " + signature.getType().getName(), (Throwable)e);
        }
        return injectionNode;
    }
}

